/*
 * Decompiled with CFR 0.152.
 */
package edu.nashcc.moodlexml;

import biz.source_code.base64Coder.Base64Coder;
import com.stevesoft.pat.Regex;
import edu.nashcc.moodlexml.Blackboard6Converter;
import edu.nashcc.moodlexml.FileUtilities;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterUtilities {
    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    private static void encodeStream(InputStream in, BufferedWriter out) throws IOException {
        int len;
        int lineLength = 72;
        byte[] buf = new byte[lineLength / 4 * 3];
        while ((len = in.read(buf)) > 0) {
            out.write(Base64Coder.encode((byte[])buf, (int)0, (int)len));
            out.newLine();
        }
    }

    public static List<List> convertImage(String strValue, int itemNumber, String[] fileList, String rootDir) {
        ArrayList<List> imageData = new ArrayList<List>();
        int counter = 0;
        Regex r = new Regex("(?i)<img.*?>");
        while (r.search(strValue)) {
            ArrayList<String> image = new ArrayList<String>();
            String path = "";
            StringBuilder imageAbsolutePath = new StringBuilder();
            ++counter;
            Regex r2 = new Regex("(?i)src=\".*?\"");
            r2.search(strValue);
            String imageTag = r2.stringMatched();
            r2 = new Regex("(?i)\".*?\"");
            r2.search(imageTag);
            path = r2.stringMatched();
            r2 = new Regex("\"", "");
            Regex r3 = new Regex("/", "\\\\");
            imageAbsolutePath.append(rootDir);
            imageAbsolutePath.append("\\");
            imageAbsolutePath.append(r2.replaceAll(path));
            path = r3.replaceAll(imageAbsolutePath.toString());
            imageTag = r2.replaceAll(imageTag);
            String[] tokens = imageTag.split("/");
            image.add(tokens[tokens.length - 1]);
            if (!FileUtilities.FileOrDirectoryExists(path) && fileList != null) {
                r3 = new Regex(FileUtilities.convert(tokens[tokens.length - 1]));
                r3.setIgnoreCase(true);
                path = FileUtilities.findFile(rootDir, r3, fileList);
            }
            try {
                File imageFile = new File(path);
                FileInputStream fis = new FileInputStream(imageFile);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                try {
                    int readNum;
                    while ((readNum = fis.read(buf)) != -1) {
                        bos.write(buf, 0, readNum);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Blackboard6Converter.class.getName()).log(Level.SEVERE, null, ex);
                }
                byte[] fileBArray = bos.toByteArray();
                image.add(Base64Coder.encodeLines((byte[])fileBArray));
                image.add(String.valueOf(itemNumber));
                fis.close();
                bos.close();
                imageData.add(image);
                strValue = r.right();
            }
            catch (NullPointerException ex) {
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(new JFrame(), "The image file specified could not be found in the export zip file. Image data will not be added to the Moodle XML.", "File Not Found", 0);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable IO error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "IO Error", 0);
                System.exit(-1);
            }
        }
        return imageData;
    }

    public static String convertImageTags(String text) {
        StringBuilder textBuilder = new StringBuilder();
        int count = 0;
        Regex r = new Regex("(?i)<img.*?>");
        while (r.search(text)) {
            ++count;
            Regex r2 = new Regex("(?i)src=\".*?\"");
            r2.search(text);
            String imageTag = r2.stringMatched();
            r2 = new Regex("\"", "");
            imageTag = r2.replaceAll(imageTag);
            String[] tokens = imageTag.split("/");
            String imageFile = tokens[tokens.length - 1];
            r2 = new Regex(" ", "%20");
            imageFile = r2.replaceAll(imageFile);
            StringBuilder builder = new StringBuilder("src=\"@@PLUGINFILE@@/");
            builder.append(imageFile);
            imageTag = builder.append("\"").toString();
            r2 = new Regex("(?i)src=\".*?\"", imageTag);
            text = r2.replaceFirst(text);
            textBuilder.append(r.left());
            r2 = new Regex("(?i)<img.*?>");
            r2.search(text);
            textBuilder.append(r2.stringMatched());
            text = r.right();
        }
        if (text != "") {
            textBuilder.append(text);
        }
        return textBuilder.toString();
    }

    public static String convert2Base64(String imageAbsolutePath) {
        String imageData = "";
        try {
            File imageFile = new File(imageAbsolutePath);
            FileInputStream fis = new FileInputStream(imageFile);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            try {
                int readNum;
                while ((readNum = fis.read(buf)) != -1) {
                    bos.write(buf, 0, readNum);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Blackboard6Converter.class.getName()).log(Level.SEVERE, null, ex);
            }
            byte[] fileBArray = bos.toByteArray();
            imageData = Base64Coder.encodeLines((byte[])fileBArray);
            fis.close();
            bos.close();
        }
        catch (NullPointerException ex) {
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(new JFrame(), "The image file specified could not be found in the export zip file. Image data will not be added to the Moodle XML.", "File Not Found", 0);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable IO error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "IO Error", 0);
            System.exit(-1);
        }
        return imageData;
    }

    public static String roundTwoDecimals(float f) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return twoDForm.format(f);
    }

    public static String cleanHTML(String html) {
        if (html == null) {
            return null;
        }
        Whitelist whitelist = new Whitelist();
        whitelist.addTags(new String[]{"a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "div", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img", "li", "ol", "p", "pre", "q", "small", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul"});
        whitelist.addAttributes("a", new String[]{"href", "title"});
        whitelist.addAttributes("blockquote", new String[]{"cite"});
        whitelist.addAttributes("col", new String[]{"span", "width"});
        whitelist.addAttributes("colgroup", new String[]{"span", "width"});
        whitelist.addAttributes("img", new String[]{"align", "alt", "height", "src", "title", "width", "border"});
        whitelist.addAttributes("ol", new String[]{"start", "type"});
        whitelist.addAttributes("q", new String[]{"cite"});
        whitelist.addAttributes("table", new String[]{"summary", "width"});
        whitelist.addAttributes("td", new String[]{"abbr", "axis", "colspan", "rowspan", "width"});
        whitelist.addAttributes("th", new String[]{"abbr", "axis", "colspan", "rowspan", "scope", "width"});
        whitelist.addAttributes("ul", new String[]{"type"});
        whitelist.addProtocols("a", "href", new String[]{"ftp", "http", "https", "mailto"});
        whitelist.addProtocols("blockquote", "cite", new String[]{"http", "https"});
        whitelist.addProtocols("q", "cite", new String[]{"http", "https"});
        html = Jsoup.clean((String)html, (Whitelist)whitelist);
        return html;
    }

    public static double round(double valueToRound, int numberOfDecimalPlaces) {
        double multipicationFactor = Math.pow(10.0, numberOfDecimalPlaces);
        double interestedInZeroDPs = valueToRound * multipicationFactor;
        return (double)Math.round(interestedInZeroDPs) / multipicationFactor;
    }

    public static String html2text(String html) {
        if (html == null) {
            return null;
        }
        html = Jsoup.parse((String)html).text();
        Regex r = new Regex("&", "and");
        html = r.replaceAll(html);
        r = new Regex("<", "less than");
        html = r.replaceAll(html);
        r = new Regex(">", "greater than");
        html = r.replaceAll(html);
        html = html.replaceAll("[^\\p{ASCII}]", "");
        return html;
    }
}

