/*
 * Decompiled with CFR 0.152.
 */
package edu.nashcc.moodlexmlbuilder.view;

import edu.nashcc.moodlexmlbuilder.view.AboutBox;
import edu.nashcc.moodlexmlbuilder.view.Blackboard6Task;
import edu.nashcc.moodlexmlbuilder.view.Blackboard7plusTask;
import edu.nashcc.moodlexmlbuilder.view.Updater;
import edu.nashcc.moodlexmlbuilder.view.WindowUtilities;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MoodleXMLBuilderView
extends JFrame {
    public static final int ONE_SECOND = 1000;
    private Blackboard6Task bb6Task;
    private Blackboard7plusTask bb7Task;
    private boolean isBB7 = false;
    private ProgressMonitor progressMonitor;
    private Timer timer;
    private Image im = Toolkit.getDefaultToolkit().getImage("moodle_icon.jpg");
    public static String appVersion = "0.4.0 beta";
    private JMenuItem aboutMenuItem;
    private JRadioButton blackboardRadioButton;
    private JButton clearButton;
    private JRadioButton examView6RadioButton;
    private JRadioButton examView7PlusRadioButton;
    private JButton exitButton;
    private JMenuItem exitMenuItem;
    private JRadioButton ezTestRadioButton;
    private JPanel fileChooserPanel;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JLabel inputFileLabel;
    private JMenuItem inputFileMenuItem;
    private JMenuBar jMenuBar1;
    private JPopupMenu.Separator jSeparator1;
    private JFileChooser openFileChooser;
    private JTextField openFileTextField;
    private JMenuItem outFileMenuItem;
    private JLabel outputFileLabel;
    private JLabel questionNamePrefixLabel;
    private JPanel questionNamePrefixPanel;
    private JTextField questionNamePrefixTextField;
    private JFileChooser saveFileChooser;
    private JTextField saveFileTextField;
    private JButton startButton;
    private JRadioButton testGenRadioButton;
    private JPanel testGeneratorPanel;

    public MoodleXMLBuilderView() {
        WindowUtilities.setNativeLookAndFeel();
        this.splashInit();
        this.initComponents();
        try {
            Object[] choices;
            ImageIcon iconImage;
            int response;
            if (!appVersion.equals(Updater.getLatestVersion()) && (response = JOptionPane.showOptionDialog(new JFrame(), "There is a new version of MoodleXMLBuilder avaiable.\nWould you like to donwload the new version now?", "Update Available", 0, 3, iconImage = new ImageIcon("moodle_icon.jpg"), choices = new String[]{"Download", "Not Now"}, "Download")) == 0) {
                JOptionPane.showMessageDialog(new JFrame(), "The download will start momentarily.\nAfter the download is complete,\nMoodleXMLBuider must be closed prior to installation.", "Download Initiated", 1, iconImage);
                URI uri = new URI("http://www.nashcc.edu/index.php?option=com_remository&Itemid=248&func=startdown&id=1864");
                AboutBox.open(uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startButton.addActionListener(new ButtonListener());
        this.timer = new Timer(1000, new TimerListener());
        this.groupButtons();
    }

    private void initComponents() {
        this.openFileChooser = new JFileChooser();
        this.saveFileChooser = new JFileChooser();
        this.testGeneratorPanel = new JPanel();
        this.examView6RadioButton = new JRadioButton();
        this.examView7PlusRadioButton = new JRadioButton();
        this.ezTestRadioButton = new JRadioButton();
        this.testGenRadioButton = new JRadioButton();
        this.blackboardRadioButton = new JRadioButton();
        this.fileChooserPanel = new JPanel();
        JLabel openFileImageLabel = new JLabel();
        JLabel saveFileImageLabel = new JLabel();
        this.openFileTextField = new JTextField();
        this.inputFileLabel = new JLabel();
        this.outputFileLabel = new JLabel();
        this.saveFileTextField = new JTextField();
        this.startButton = new JButton();
        this.exitButton = new JButton();
        this.clearButton = new JButton();
        this.questionNamePrefixPanel = new JPanel();
        this.questionNamePrefixLabel = new JLabel();
        this.questionNamePrefixTextField = new JTextField();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.inputFileMenuItem = new JMenuItem();
        this.outFileMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.saveFileChooser.setDialogType(1);
        this.setDefaultCloseOperation(3);
        this.setTitle("Moodle XML Builder  -  Nash Community College");
        this.setIconImage(this.im);
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MoodleXMLBuilderView.this.formWindowClosing(evt);
            }
        });
        this.testGeneratorPanel.setBorder(BorderFactory.createTitledBorder("Test Generator"));
        this.testGeneratorPanel.setName("testGeneratorPanel");
        this.examView6RadioButton.setSelected(true);
        this.examView6RadioButton.setText("ExamView Export to Blackboard 6.0-7.0");
        this.examView6RadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.examView6RadioButtonActionPerformed(evt);
            }
        });
        this.examView7PlusRadioButton.setText("ExamView Export to Blackboard 7.1+");
        this.examView7PlusRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.examView7PlusRadioButtonActionPerformed(evt);
            }
        });
        this.ezTestRadioButton.setText("EZ Test Export to BlackBoard");
        this.ezTestRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.ezTestRadioButtonActionPerformed(evt);
            }
        });
        this.testGenRadioButton.setText("TestGen Export to Blackboard 6.x-9.x");
        this.testGenRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.testGenRadioButtonActionPerformed(evt);
            }
        });
        this.blackboardRadioButton.setLabel("Blackboard Test Exported from Blackboard");
        this.blackboardRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.blackboardRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout testGeneratorPanelLayout = new GroupLayout(this.testGeneratorPanel);
        this.testGeneratorPanel.setLayout(testGeneratorPanelLayout);
        testGeneratorPanelLayout.setHorizontalGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testGeneratorPanelLayout.createSequentialGroup().addGap(16, 16, 16).addGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.blackboardRadioButton).addComponent(this.testGenRadioButton).addComponent(this.ezTestRadioButton).addComponent(this.examView7PlusRadioButton).addComponent(this.examView6RadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        testGeneratorPanelLayout.setVerticalGroup(testGeneratorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testGeneratorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.examView6RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.examView7PlusRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ezTestRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testGenRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.blackboardRadioButton).addContainerGap()));
        this.fileChooserPanel.setBorder(BorderFactory.createTitledBorder("File Chooser"));
        openFileImageLabel.setIcon(new ImageIcon(this.getClass().getResource("/edu/nashcc/moodlexmlbuilder/view/resources/samples.png")));
        openFileImageLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MoodleXMLBuilderView.this.openFileImageLabelMouseClicked(evt);
            }
        });
        saveFileImageLabel.setIcon(new ImageIcon(this.getClass().getResource("/edu/nashcc/moodlexmlbuilder/view/resources/samples.png")));
        saveFileImageLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MoodleXMLBuilderView.this.saveFileImageLabelMouseClicked(evt);
            }
        });
        this.inputFileLabel.setText("ExamView Input File Name");
        this.outputFileLabel.setText("Moodle XML Output File Name");
        GroupLayout fileChooserPanelLayout = new GroupLayout(this.fileChooserPanel);
        this.fileChooserPanel.setLayout(fileChooserPanelLayout);
        fileChooserPanelLayout.setHorizontalGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileChooserPanelLayout.createSequentialGroup().addContainerGap().addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileChooserPanelLayout.createSequentialGroup().addComponent(openFileImageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.openFileTextField, -2, 345, -2)).addGroup(fileChooserPanelLayout.createSequentialGroup().addComponent(saveFileImageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.saveFileTextField, -1, 345, Short.MAX_VALUE).addComponent(this.outputFileLabel)))).addContainerGap()).addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileChooserPanelLayout.createSequentialGroup().addGap(52, 52, 52).addComponent(this.inputFileLabel).addContainerGap(229, Short.MAX_VALUE))));
        fileChooserPanelLayout.setVerticalGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileChooserPanelLayout.createSequentialGroup().addContainerGap().addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.openFileTextField, -2, -1, -2).addComponent(openFileImageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(saveFileImageLabel).addGroup(fileChooserPanelLayout.createSequentialGroup().addComponent(this.outputFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveFileTextField, -2, -1, -2))).addGap(20, 20, 20)).addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileChooserPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.inputFileLabel).addContainerGap(115, Short.MAX_VALUE))));
        this.startButton.setText("Start");
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.exitButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.clearButtonActionPerformed(evt);
            }
        });
        this.questionNamePrefixPanel.setBorder(BorderFactory.createTitledBorder("Question Name Prefix"));
        this.questionNamePrefixLabel.setText("<html>Enter a prefix that will be inserted at the begiining of the question name (optional) </html>");
        this.questionNamePrefixLabel.setVerticalAlignment(1);
        this.questionNamePrefixLabel.setVerticalTextPosition(1);
        GroupLayout questionNamePrefixPanelLayout = new GroupLayout(this.questionNamePrefixPanel);
        this.questionNamePrefixPanel.setLayout(questionNamePrefixPanelLayout);
        questionNamePrefixPanelLayout.setHorizontalGroup(questionNamePrefixPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(questionNamePrefixPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.questionNamePrefixLabel, -1, 221, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.questionNamePrefixTextField, -2, 162, -2).addGap(8, 8, 8)));
        questionNamePrefixPanelLayout.setVerticalGroup(questionNamePrefixPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, questionNamePrefixPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(questionNamePrefixPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.questionNamePrefixTextField, -2, -1, -2).addComponent(this.questionNamePrefixLabel, -2, -1, -2)).addContainerGap()));
        this.fileMenu.setText("File");
        this.inputFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.inputFileMenuItem.setText("Input File");
        this.inputFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.inputFileMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.inputFileMenuItem);
        this.outFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.outFileMenuItem.setText("Output File");
        this.outFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.outFileMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.outFileMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MoodleXMLBuilderView.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.testGeneratorPanel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(55, 55, 55).addComponent(this.startButton, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton, -2, 59, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.questionNamePrefixPanel, 0, 419, Short.MAX_VALUE).addComponent(this.fileChooserPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(20, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fileChooserPanel, -1, -1, Short.MAX_VALUE).addComponent(this.testGeneratorPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exitButton).addComponent(this.clearButton).addComponent(this.startButton))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.questionNamePrefixPanel, -2, -1, -2))).addContainerGap()));
        this.pack();
    }

    private void examView6RadioButtonActionPerformed(ActionEvent evt) {
        this.inputFileLabel.setText("ExamView Input File Name");
    }

    private void examView7PlusRadioButtonActionPerformed(ActionEvent evt) {
        this.inputFileLabel.setText("ExamView Input File Name");
    }

    private void ezTestRadioButtonActionPerformed(ActionEvent evt) {
        this.inputFileLabel.setText("EZ Test Input File Name");
    }

    private void testGenRadioButtonActionPerformed(ActionEvent evt) {
        this.inputFileLabel.setText("TestGen Input File Name");
    }

    private void openFileImageLabelMouseClicked(MouseEvent evt) {
        this.openFileDialog();
    }

    private void saveFileImageLabelMouseClicked(MouseEvent evt) {
        this.saveFileDialog();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.saveFileTextField.setText("");
        this.openFileTextField.setText("");
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.progressMonitor.close();
            if (!this.isBB7) {
                this.bb6Task.stop();
            } else {
                this.bb7Task.stop();
            }
        }
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.progressMonitor.close();
            if (!this.isBB7) {
                this.bb6Task.stop();
            } else {
                this.bb7Task.stop();
            }
        }
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    private void inputFileMenuItemActionPerformed(ActionEvent evt) {
        this.openFileDialog();
    }

    private void outFileMenuItemActionPerformed(ActionEvent evt) {
        this.saveFileDialog();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        JFrame about = new JFrame();
        AboutBox dlg = new AboutBox(about);
        dlg.setLocationByPlatform(true);
        dlg.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.progressMonitor.close();
            if (!this.isBB7) {
                this.bb6Task.stop();
            } else {
                this.bb7Task.stop();
            }
        }
    }

    private void blackboardRadioButtonActionPerformed(ActionEvent evt) {
        this.inputFileLabel.setText("Blackboard Input File Name");
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File("MoodleXMLBuilder Help.pdf");
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "There is no application registered to open PDF files.", "No Application Registered", 0);
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MoodleXMLBuilderView().setVisible(true);
            }
        });
    }

    private void groupButtons() {
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.examView6RadioButton);
        bg1.add(this.examView7PlusRadioButton);
        bg1.add(this.ezTestRadioButton);
        bg1.add(this.testGenRadioButton);
        bg1.add(this.blackboardRadioButton);
    }

    private void openFileDialog() {
        FileNameExtensionFilter zipFilter = new FileNameExtensionFilter("Zip Files", "zip");
        this.openFileChooser.addChoosableFileFilter(zipFilter);
        this.openFileChooser.setAcceptAllFileFilterUsed(false);
        int returnVal = this.openFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            // empty if block
        }
        File file = this.openFileChooser.getSelectedFile();
        int dotPos = file.toString().lastIndexOf(".");
        String extension = file.toString().substring(dotPos).toLowerCase(Locale.US);
        if (extension.equals(".zip")) {
            this.openFileTextField.setText(file.toString());
            if (this.saveFileTextField.getText().equals("")) {
                StringBuilder filename = new StringBuilder(file.toString().substring(0, dotPos));
                filename.append(".xml");
                this.saveFileTextField.setText(filename.toString());
            }
        } else {
            JOptionPane.showMessageDialog(this, "The selected file must be a \"zip\" file.\nPlease try again.", "Wrong File Type", 0);
        }
    }

    private void saveFileDialog() {
        FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("XML Files", "xml");
        this.saveFileChooser.addChoosableFileFilter(xmlFilter);
        this.saveFileChooser.setAcceptAllFileFilterUsed(false);
        int returnVal = this.saveFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            // empty if block
        }
        File file = this.saveFileChooser.getSelectedFile();
        int dotPos = file.toString().lastIndexOf(".");
        String extension = file.toString().substring(dotPos).toLowerCase(Locale.US);
        if (extension.equals(".xml")) {
            this.saveFileTextField.setText(file.toString());
        } else {
            JOptionPane.showMessageDialog(this, "The selected file must be a \"xml\" file.\nPlease try again.", "Wrong File Type", 0);
        }
    }

    private void splashInit() {
        SplashScreen mySplash = SplashScreen.getSplashScreen();
        if (mySplash != null && mySplash != null) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            mySplash.close();
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            StringBuilder messageBuilder = new StringBuilder("Converting ");
            if (MoodleXMLBuilderView.this.examView6RadioButton.isSelected()) {
                messageBuilder.append("ExamView to Moodle XML.");
                MoodleXMLBuilderView.this.isBB7 = false;
            } else if (MoodleXMLBuilderView.this.examView7PlusRadioButton.isSelected()) {
                messageBuilder.append("ExamView to Moodle XML.");
                MoodleXMLBuilderView.this.isBB7 = true;
            } else if (MoodleXMLBuilderView.this.ezTestRadioButton.isSelected()) {
                messageBuilder.append("EZ Test to Moodle XML.");
                MoodleXMLBuilderView.this.isBB7 = false;
            } else if (MoodleXMLBuilderView.this.testGenRadioButton.isSelected()) {
                messageBuilder.append("TestGen to Moodle XML.");
                MoodleXMLBuilderView.this.isBB7 = true;
            } else if (MoodleXMLBuilderView.this.blackboardRadioButton.isSelected()) {
                messageBuilder.append("Blackboard to Moodle XML.");
                MoodleXMLBuilderView.this.isBB7 = true;
            }
            int dotPos = MoodleXMLBuilderView.this.openFileTextField.getText().lastIndexOf(".");
            String extension = MoodleXMLBuilderView.this.openFileTextField.getText().substring(dotPos).toLowerCase(Locale.US);
            boolean zip = extension.equals(".zip");
            dotPos = MoodleXMLBuilderView.this.saveFileTextField.getText().lastIndexOf(".");
            extension = MoodleXMLBuilderView.this.saveFileTextField.getText().substring(dotPos).toLowerCase(Locale.US);
            boolean xml = extension.equals(".xml");
            if (zip && xml) {
                if (!MoodleXMLBuilderView.this.isBB7) {
                    MoodleXMLBuilderView.this.bb6Task = new Blackboard6Task();
                    ((MoodleXMLBuilderView)MoodleXMLBuilderView.this).bb6Task.zipFile = MoodleXMLBuilderView.this.openFileTextField.getText();
                    ((MoodleXMLBuilderView)MoodleXMLBuilderView.this).bb6Task.outputFile = MoodleXMLBuilderView.this.saveFileTextField.getText();
                    ((MoodleXMLBuilderView)MoodleXMLBuilderView.this).bb6Task.namePrefix = MoodleXMLBuilderView.this.questionNamePrefixTextField.getText();
                    MoodleXMLBuilderView.this.progressMonitor = new ProgressMonitor(MoodleXMLBuilderView.this, messageBuilder.toString(), "", 0, MoodleXMLBuilderView.this.bb6Task.getLengthOfTask());
                } else {
                    MoodleXMLBuilderView.this.bb7Task = new Blackboard7plusTask();
                    ((MoodleXMLBuilderView)MoodleXMLBuilderView.this).bb7Task.zipFile = MoodleXMLBuilderView.this.openFileTextField.getText();
                    ((MoodleXMLBuilderView)MoodleXMLBuilderView.this).bb7Task.outputFile = MoodleXMLBuilderView.this.saveFileTextField.getText();
                    ((MoodleXMLBuilderView)MoodleXMLBuilderView.this).bb7Task.namePrefix = MoodleXMLBuilderView.this.questionNamePrefixTextField.getText();
                    MoodleXMLBuilderView.this.progressMonitor = new ProgressMonitor(MoodleXMLBuilderView.this, messageBuilder.toString(), "", 0, MoodleXMLBuilderView.this.bb7Task.getLengthOfTask());
                }
                MoodleXMLBuilderView.this.progressMonitor.setProgress(0);
                MoodleXMLBuilderView.this.progressMonitor.setMillisToDecideToPopup(2000);
                MoodleXMLBuilderView.this.clearButton.setEnabled(false);
                MoodleXMLBuilderView.this.saveFileTextField.setEnabled(false);
                MoodleXMLBuilderView.this.openFileTextField.setEnabled(false);
                MoodleXMLBuilderView.this.startButton.setEnabled(false);
                if (!MoodleXMLBuilderView.this.isBB7) {
                    MoodleXMLBuilderView.this.bb6Task.go();
                } else {
                    MoodleXMLBuilderView.this.bb7Task.go();
                }
                MoodleXMLBuilderView.this.timer.start();
            } else if (!zip) {
                JOptionPane.showMessageDialog(new JFrame(), "The input file type must be a \"zip\" file.\nPlease try again.", "Wrong File Type", 0);
            } else if (!xml) {
                JOptionPane.showMessageDialog(new JFrame(), "The output file type must be a \"xml\" file.\nPlease try again.", "Wrong File Type", 0);
            }
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            boolean isTaskDone = !MoodleXMLBuilderView.this.isBB7 ? MoodleXMLBuilderView.this.bb6Task.done() : MoodleXMLBuilderView.this.bb7Task.done();
            if (MoodleXMLBuilderView.this.progressMonitor.isCanceled() || isTaskDone) {
                MoodleXMLBuilderView.this.progressMonitor.close();
                if (!MoodleXMLBuilderView.this.isBB7) {
                    MoodleXMLBuilderView.this.bb6Task.stop();
                } else {
                    MoodleXMLBuilderView.this.bb7Task.stop();
                }
                Toolkit.getDefaultToolkit().beep();
                MoodleXMLBuilderView.this.timer.stop();
                MoodleXMLBuilderView.this.startButton.setEnabled(true);
                MoodleXMLBuilderView.this.clearButton.setEnabled(true);
                MoodleXMLBuilderView.this.saveFileTextField.setEnabled(true);
                MoodleXMLBuilderView.this.openFileTextField.setEnabled(true);
                MoodleXMLBuilderView.this.saveFileTextField.setText("");
                MoodleXMLBuilderView.this.openFileTextField.setText("");
            } else if (!MoodleXMLBuilderView.this.isBB7) {
                MoodleXMLBuilderView.this.progressMonitor.setNote(MoodleXMLBuilderView.this.bb6Task.getMessage());
                MoodleXMLBuilderView.this.progressMonitor.setProgress(MoodleXMLBuilderView.this.bb6Task.getCurrent());
            } else {
                MoodleXMLBuilderView.this.progressMonitor.setNote(MoodleXMLBuilderView.this.bb7Task.getMessage());
                MoodleXMLBuilderView.this.progressMonitor.setProgress(MoodleXMLBuilderView.this.bb7Task.getCurrent());
            }
        }
    }
}

