/*
 * Decompiled with CFR 0.152.
 */
package edu.nashcc.moodlexml;

import com.stevesoft.pat.Regex;
import edu.nashcc.moodlexml.ConverterUtilities;
import edu.nashcc.moodlexml.FileUtilities;
import edu.nashcc.moodlexmlbuilder.Essay;
import edu.nashcc.moodlexmlbuilder.Matching;
import edu.nashcc.moodlexmlbuilder.MultiChoice;
import edu.nashcc.moodlexmlbuilder.ShortAnswer;
import edu.nashcc.moodlexmlbuilder.TrueFalse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class Blackboard6Converter {
    public int percentComplete = 0;
    public File zipFileFolder;
    public File outFile;
    public FileOutputStream outFileStream;
    public OutputStreamWriter xmlOutFile;
    private FileInputStream inFileStream;
    private InputStreamReader xmlInFile;
    private File inFile;

    public void ParseBlackboard6XML(String zipFileName, String outFileName, String namePrefix) {
        boolean unzipped;
        block87: {
            boolean headerPresent = false;
            StringBuilder questionXML = new StringBuilder();
            FileUtilities.extractFolder(zipFileName);
            String rootDir = zipFileName.substring(0, zipFileName.length() - 4);
            rootDir = rootDir == null || rootDir.equals("") ? "." : rootDir;
            this.zipFileFolder = new File(rootDir);
            unzipped = true;
            String[] fileList = this.zipFileFolder.list();
            String inFileName = "";
            if (fileList != null) {
                Regex r = new Regex(FileUtilities.convert("*.dat"));
                r.setIgnoreCase(true);
                inFileName = FileUtilities.findFile(rootDir, r, fileList);
                if (inFileName == null || inFileName.equals("")) {
                    JOptionPane.showMessageDialog(new JFrame(), "There was an error locating the required file.\nEnsure you selected the zip file exported by\nyour test generator and please try again?", "File Not Found", 0);
                    boolean dirDelete = FileUtilities.removeDirectory(this.zipFileFolder);
                    this.percentComplete = 100;
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "There were no files found in the zip file selected.\nEnsure you selected the zip file exported by\nyour test generator and please try again?", "File Not Found", 0);
                boolean dirDelete = FileUtilities.removeDirectory(this.zipFileFolder);
                this.percentComplete = 100;
                return;
            }
            try {
                boolean badFile = false;
                boolean single = true;
                this.inFile = new File(inFileName);
                this.outFile = new File(outFileName);
                this.inFileStream = new FileInputStream(this.inFile);
                this.xmlInFile = new InputStreamReader((InputStream)this.inFileStream, "UTF8");
                this.outFileStream = new FileOutputStream(this.outFile);
                this.xmlOutFile = new OutputStreamWriter((OutputStream)this.outFileStream, "UTF8");
                Builder builder = new Builder();
                Document doc = builder.build((Reader)this.xmlInFile);
                Element root = doc.getRootElement();
                String title = "";
                try {
                    title = root.getFirstChildElement("TITLE").getAttributeValue("value");
                }
                catch (NullPointerException ex) {
                    JOptionPane.showMessageDialog(new JFrame(), "The file selected is not the correct format.\nEnsure you selected the correct test\ngenerator format and please try again?", "Wrong File Format", 0);
                    boolean dirDelete = FileUtilities.removeDirectory(this.zipFileFolder);
                    this.percentComplete = 100;
                    return;
                }
                Elements questions = root.getFirstChildElement("QUESTIONLIST").getChildElements();
                for (int i = 0; i < questions.size(); ++i) {
                    String correctFeedback = "";
                    List<Object> correctFeedbackImageInfo = new ArrayList();
                    String incorrectFeedback = "";
                    List<Object> incorrectFeedbackImageInfo = new ArrayList();
                    String generalFeedback = "";
                    List<Object> generalFeedbackImageInfo = new ArrayList();
                    String questionText = "";
                    List<Object> questionImageInfo = new ArrayList();
                    Element element = questions.get(i);
                    String questionType = element.getAttributeValue("class");
                    String name = element.getAttributeValue("id");
                    String[] answer = new String[]{};
                    String[] choice = new String[]{};
                    ArrayList<List> answerImageInfo = new ArrayList<List>();
                    String[] fraction = new String[]{};
                    Elements allElements = root.getChildElements();
                    for (int x = 0; x < allElements.size(); ++x) {
                        Element questionElement = allElements.get(x);
                        try {
                            int j;
                            int j2;
                            if (!questionElement.getAttributeValue("id").equals(name)) continue;
                            questionText = questionElement.getFirstChildElement("BODY").getFirstChildElement("TEXT").getValue();
                            StringBuilder appendName = new StringBuilder(namePrefix.trim());
                            if (!appendName.toString().equals("")) {
                                appendName.append(" ");
                            }
                            appendName.append("q");
                            int len = String.valueOf(questions.size()).length();
                            String tempName = String.valueOf(i + 1);
                            len -= tempName.length();
                            for (int j3 = 0; j3 < len; ++j3) {
                                appendName.append("0");
                            }
                            appendName.append(tempName);
                            appendName.append(" ");
                            appendName.append(ConverterUtilities.html2text(questionText));
                            name = appendName.length() > 80 ? appendName.toString().substring(0, 80) : appendName.toString();
                            Regex r = new Regex();
                            try {
                                r = new Regex("(?i)<img ");
                                r.search(questionText);
                                if (r.didMatch()) {
                                    questionImageInfo = ConverterUtilities.convertImage(questionText, 0, fileList, rootDir);
                                    questionText = ConverterUtilities.convertImageTags(questionText);
                                }
                            }
                            catch (NullPointerException ex) {
                                questionText = "";
                            }
                            Elements answers = questionElement.getChildElements("ANSWER");
                            Elements correctAnswers = questionElement.getFirstChildElement("GRADABLE").getChildElements("CORRECTANSWER");
                            Elements choices = questionElement.getChildElements("CHOICE");
                            try {
                                correctFeedback = questionElement.getFirstChildElement("GRADABLE").getFirstChildElement("FEEDBACK_WHEN_CORRECT").getValue();
                                r.search(correctFeedback);
                                if (r.didMatch()) {
                                    correctFeedbackImageInfo = ConverterUtilities.convertImage(correctFeedback, 0, fileList, rootDir);
                                    correctFeedback = ConverterUtilities.convertImageTags(correctFeedback);
                                }
                            }
                            catch (NullPointerException ex) {
                                correctFeedback = "";
                            }
                            try {
                                incorrectFeedback = questionElement.getFirstChildElement("GRADABLE").getFirstChildElement("FEEDBACK_WHEN_INCORRECT").getValue();
                                r.search(incorrectFeedback);
                                if (r.didMatch()) {
                                    incorrectFeedbackImageInfo = ConverterUtilities.convertImage(incorrectFeedback, 0, fileList, rootDir);
                                    incorrectFeedback = ConverterUtilities.convertImageTags(incorrectFeedback);
                                }
                            }
                            catch (NullPointerException ex) {
                                incorrectFeedback = "";
                            }
                            try {
                                generalFeedback = questionElement.getFirstChildElement("GRADABLE").getFirstChildElement("FEEDBACK_WHEN_CORRECT").getValue().trim();
                                r = new Regex("(?i)correct");
                                generalFeedback = r.replaceAllRegion(generalFeedback, 0, 7).trim();
                                r = new Regex("(?i)<img ");
                                r.search(generalFeedback);
                                if (r.didMatch()) {
                                    generalFeedbackImageInfo = ConverterUtilities.convertImage(generalFeedback, 0, fileList, rootDir);
                                    generalFeedback = ConverterUtilities.convertImageTags(generalFeedback);
                                }
                            }
                            catch (NullPointerException ex) {
                                generalFeedback = "";
                            }
                            String[] correctAnswer = new String[correctAnswers.size()];
                            if (!questionType.equals("QUESTION_MATCH")) {
                                if (correctAnswers.size() > 0) {
                                    for (j2 = 0; j2 < correctAnswers.size(); ++j2) {
                                        correctAnswer[j2] = correctAnswers.get(j2).getAttributeValue("answer_id").trim();
                                    }
                                }
                                if (correctAnswers.size() > 1) {
                                    single = false;
                                }
                            } else {
                                for (int j4 = 0; j4 < correctAnswers.size(); ++j4) {
                                    StringBuilder matchAnswer = new StringBuilder(correctAnswers.get(j4).getAttributeValue("answer_id").trim());
                                    matchAnswer.append(" ");
                                    matchAnswer.append(correctAnswers.get(j4).getAttributeValue("choice_id").trim());
                                    correctAnswer[j4] = matchAnswer.toString();
                                }
                            }
                            if (answers.size() > 0) {
                                fraction = (String[])ConverterUtilities.resizeArray(fraction, answers.size());
                                answer = (String[])ConverterUtilities.resizeArray(answer, answers.size());
                                for (j2 = 0; j2 < answers.size(); ++j2) {
                                    answer[j2] = answers.get(j2).getValue().trim();
                                    r.search(answer[j2]);
                                    if (r.didMatch()) {
                                        answerImageInfo.add(ConverterUtilities.convertImage(answer[j2], j2, fileList, rootDir));
                                        answer[j2] = ConverterUtilities.convertImageTags(answer[j2]);
                                    }
                                    if (questionType.equals("QUESTION_MATCH")) continue;
                                    if (correctAnswer.length > 0) {
                                        for (int k = 0; k < correctAnswer.length; ++k) {
                                            fraction[j2] = answers.get(j2).getAttributeValue("id").equals(correctAnswer[k]) ? ConverterUtilities.roundTwoDecimals(100.0f / (float)correctAnswers.size()) : "0.0";
                                        }
                                        continue;
                                    }
                                    fraction[j2] = questionType.equals("QUESTION_FILLINBLANK") ? "100.0" : "0.0";
                                }
                            }
                            if (choices.size() <= 0 || !questionType.equals("QUESTION_MATCH")) continue;
                            if (choices.size() > answer.length) {
                                answer = (String[])ConverterUtilities.resizeArray(answer, choices.size());
                            }
                            choice = (String[])ConverterUtilities.resizeArray(choice, choices.size());
                            String[] tempArray = new String[choices.size()];
                            for (j = 0; j < tempArray.length; ++j) {
                                tempArray[j] = choices.get(j).getValue().trim();
                            }
                            for (j = 0; j < correctAnswer.length; ++j) {
                                try {
                                    String[] tokens = correctAnswer[j].split("_");
                                    tokens[tokens.length - 1] = tokens[tokens.length - 1].toLowerCase(Locale.US).replace("c", "");
                                    int choiceID = Integer.valueOf(tokens[tokens.length - 1]) - 1;
                                    choice[j] = ConverterUtilities.html2text(choices.get(choiceID).getValue().trim());
                                    tempArray[choiceID] = null;
                                    continue;
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                            }
                            if (choice.length <= correctAnswer.length) continue;
                            for (j = 0; j < tempArray.length; ++j) {
                                if (tempArray[j] == null) continue;
                                for (int k = 0; k < choice.length; ++k) {
                                    if (choice[k] != null) continue;
                                    choice[k] = ConverterUtilities.html2text(tempArray[j]);
                                    tempArray[j] = null;
                                }
                            }
                            continue;
                        }
                        catch (NullPointerException ex) {
                            // empty catch block
                        }
                    }
                    if (questionType.equals("QUESTION_MULTIPLECHOICE")) {
                        MultiChoice questionBuilder = new MultiChoice();
                        questionBuilder.name = name;
                        questionBuilder.questiontext = questionText;
                        if (questionImageInfo.size() > 0) {
                            questionBuilder.questionImageList = questionImageInfo;
                        }
                        questionBuilder.generalfeedback = generalFeedback;
                        if (generalFeedbackImageInfo.size() > 0) {
                            questionBuilder.generalfeedbackImageList = generalFeedbackImageInfo;
                        }
                        questionBuilder.answer = Arrays.asList(answer);
                        questionBuilder.fraction = Arrays.asList(fraction);
                        if (answerImageInfo.size() > 0) {
                            questionBuilder.answerImageList = answerImageInfo;
                        }
                        questionBuilder.penalty = 0.33f;
                        questionBuilder.shuffleanswers = 0;
                        try {
                            questionBuilder.defaultgrade = Float.valueOf(element.getAttributeValue("points")).floatValue();
                        }
                        catch (NullPointerException ex) {
                            questionBuilder.defaultgrade = 1.0f;
                        }
                        questionBuilder.single = single;
                        if (!headerPresent) {
                            questionXML.append((CharSequence)MultiChoice.buildXMLHeader(title));
                            headerPresent = true;
                        }
                        questionXML.append((CharSequence)questionBuilder.multiChoiceXML(questionBuilder));
                        this.xmlOutFile.write(questionXML.toString());
                        questionXML.delete(0, questionXML.length() - 1);
                    } else if (questionType.equals("QUESTION_MATCH")) {
                        Matching questionBuilder = new Matching();
                        questionBuilder.name = name;
                        questionBuilder.questiontext = questionText;
                        if (questionImageInfo.size() > 0) {
                            questionBuilder.questionImageList = questionImageInfo;
                        }
                        questionBuilder.generalfeedback = generalFeedback;
                        if (generalFeedbackImageInfo.size() > 0) {
                            questionBuilder.generalfeedbackImageList = generalFeedbackImageInfo;
                        }
                        questionBuilder.subquestion = Arrays.asList(answer);
                        if (answerImageInfo.size() > 0) {
                            questionBuilder.subquestionImageList = answerImageInfo;
                        }
                        questionBuilder.answer = Arrays.asList(choice);
                        questionBuilder.penalty = 0.33f;
                        questionBuilder.shuffleanswers = 1;
                        try {
                            questionBuilder.defaultgrade = Float.valueOf(element.getAttributeValue("points")).floatValue();
                        }
                        catch (NullPointerException ex) {
                            questionBuilder.defaultgrade = 1.0f;
                        }
                        if (!headerPresent) {
                            questionXML.append((CharSequence)MultiChoice.buildXMLHeader(title));
                            headerPresent = true;
                        }
                        questionXML.append((CharSequence)questionBuilder.matchingXML(questionBuilder));
                        this.xmlOutFile.write(questionXML.toString());
                        questionXML.delete(0, questionXML.length() - 1);
                    } else if (questionType.equals("QUESTION_TRUEFALSE")) {
                        TrueFalse questionBuilder = new TrueFalse();
                        questionBuilder.name = name;
                        questionBuilder.questiontext = questionText;
                        if (questionImageInfo.size() > 0) {
                            questionBuilder.questionImageList = questionImageInfo;
                        }
                        questionBuilder.generalfeedback = generalFeedback;
                        if (generalFeedbackImageInfo.size() > 0) {
                            questionBuilder.generalfeedbackImageList = generalFeedbackImageInfo;
                        }
                        for (int j = 0; j < answer.length; ++j) {
                            if (answer[j].toLowerCase(Locale.US).equals("yes")) {
                                answer[j] = "true";
                            }
                            if (!answer[j].toLowerCase(Locale.US).equals("no")) continue;
                            answer[j] = "false";
                        }
                        questionBuilder.answer = Arrays.asList(answer);
                        questionBuilder.fraction = Arrays.asList(fraction);
                        questionBuilder.penalty = 1.0f;
                        questionBuilder.shuffleanswers = 0;
                        try {
                            questionBuilder.defaultgrade = Float.valueOf(element.getAttributeValue("points")).floatValue();
                        }
                        catch (NullPointerException ex) {
                            questionBuilder.defaultgrade = 1.0f;
                        }
                        if (!headerPresent) {
                            questionXML.append((CharSequence)TrueFalse.buildXMLHeader(title));
                            headerPresent = true;
                        }
                        questionXML.append((CharSequence)questionBuilder.trueFalseXML(questionBuilder));
                        this.xmlOutFile.write(questionXML.toString());
                        questionXML.delete(0, questionXML.length() - 1);
                    } else if (questionType.equals("QUESTION_FILLINBLANK")) {
                        ShortAnswer questionBuilder = new ShortAnswer();
                        questionBuilder.name = name;
                        questionBuilder.questiontext = questionText;
                        if (questionImageInfo.size() > 0) {
                            questionBuilder.questionImageList = questionImageInfo;
                        }
                        questionBuilder.generalfeedback = generalFeedback;
                        if (generalFeedbackImageInfo.size() > 0) {
                            questionBuilder.generalfeedbackImageList = generalFeedbackImageInfo;
                        }
                        questionBuilder.answer = Arrays.asList(answer);
                        questionBuilder.fraction = Arrays.asList(fraction);
                        questionBuilder.penalty = 0.33f;
                        questionBuilder.shuffleanswers = 0;
                        try {
                            questionBuilder.defaultgrade = Float.valueOf(element.getAttributeValue("points")).floatValue();
                        }
                        catch (NullPointerException ex) {
                            questionBuilder.defaultgrade = 1.0f;
                        }
                        if (!headerPresent) {
                            questionXML.append((CharSequence)ShortAnswer.buildXMLHeader(title));
                            headerPresent = true;
                        }
                        questionXML.append((CharSequence)questionBuilder.shortAnswerXML(questionBuilder));
                        this.xmlOutFile.write(questionXML.toString());
                        questionXML.delete(0, questionXML.length() - 1);
                    } else if (questionType.equals("QUESTION_ESSAY")) {
                        Essay questionBuilder = new Essay();
                        questionBuilder.name = name;
                        questionBuilder.questiontext = questionText;
                        if (questionImageInfo.size() > 0) {
                            questionBuilder.questionImageList = questionImageInfo;
                        }
                        questionBuilder.graderinfo = Arrays.asList(answer);
                        if (answerImageInfo.size() > 0) {
                            questionBuilder.graderinfoImageList = answerImageInfo;
                        }
                        questionBuilder.penalty = 0.1f;
                        try {
                            questionBuilder.defaultgrade = Float.valueOf(element.getAttributeValue("points")).floatValue();
                        }
                        catch (NullPointerException ex) {
                            questionBuilder.defaultgrade = 1.0f;
                        }
                        if (!headerPresent) {
                            questionXML.append((CharSequence)Essay.buildXMLHeader(title));
                            headerPresent = true;
                        }
                        questionXML.append((CharSequence)questionBuilder.essayXML(questionBuilder));
                        this.xmlOutFile.write(questionXML.toString());
                        questionXML.delete(0, questionXML.length() - 1);
                    }
                    this.percentComplete = (int)Math.floor((double)(i + 1) / (double)questions.size() * 100.0);
                }
                Essay endQuiz = new Essay();
                this.xmlOutFile.write(endQuiz.closeQuiz());
                this.xmlInFile.close();
                this.inFileStream.close();
                this.xmlOutFile.flush();
                this.xmlOutFile.close();
                this.outFileStream.flush();
                this.outFileStream.close();
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable file not found error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "File Not Found Error", 0);
                if (unzipped) {
                    FileUtilities.removeDirectory(this.zipFileFolder);
                }
                System.exit(-1);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable IO error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "IO Error", 0);
                if (unzipped) {
                    FileUtilities.removeDirectory(this.zipFileFolder);
                }
                System.exit(-1);
            }
            catch (ParsingException e) {
                JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable XML parse error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "XML Parse Error", 0);
                if (unzipped) {
                    FileUtilities.removeDirectory(this.zipFileFolder);
                }
                System.exit(-1);
            }
            catch (NullPointerException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "There was an error processing the file.\nRe-export the file in your test generator\nand please try again?", "Processing Error", 0);
                if (!unzipped) break block87;
                FileUtilities.removeDirectory(this.zipFileFolder);
            }
        }
        boolean dirDelete = FileUtilities.removeDirectory(this.zipFileFolder);
        unzipped = false;
        this.percentComplete = 100;
    }
}

