/*
 * Decompiled with CFR 0.152.
 */
package edu.nashcc.moodlexml;

import com.stevesoft.pat.Regex;
import edu.nashcc.moodlexml.ConverterUtilities;
import edu.nashcc.moodlexml.FileUtilities;
import edu.nashcc.moodlexmlbuilder.Essay;
import edu.nashcc.moodlexmlbuilder.Matching;
import edu.nashcc.moodlexmlbuilder.MultiChoice;
import edu.nashcc.moodlexmlbuilder.Numerical;
import edu.nashcc.moodlexmlbuilder.ShortAnswer;
import edu.nashcc.moodlexmlbuilder.TrueFalse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class Blackboard7plusConverter {
    public int percentComplete = 0;
    public File zipFileFolder;
    public File outFile;
    public FileOutputStream outFileStream;
    public OutputStreamWriter xmlOutFile;
    private FileInputStream inFileStream;
    private InputStreamReader xmlInFile;
    private File inFile;
    protected List<String> inputFiles = new ArrayList<String>();

    public void ParseBlackboard7plusXML(String zipFileName, String outFileName, String namePrefix) {
        boolean headerPresent = false;
        StringBuilder questionXML = new StringBuilder();
        FileUtilities.extractFolder(zipFileName);
        String rootDir = zipFileName.substring(0, zipFileName.length() - 4);
        rootDir = rootDir == null || rootDir.equals("") ? "." : rootDir;
        this.zipFileFolder = new File(rootDir);
        boolean unzipped = true;
        String[] fileList = this.zipFileFolder.list();
        if (fileList != null) {
            Regex r = new Regex(FileUtilities.convert("*.dat"));
            r.setIgnoreCase(true);
            this.findFiles(rootDir, r, fileList);
            if (this.inputFiles.isEmpty()) {
                JOptionPane.showMessageDialog(new JFrame(), "There was an error locating the required file.\nEnsure you selected the zip file exported by\nyour test generator and please try again?", "File Not Found", 0);
                boolean dirDelete = FileUtilities.removeDirectory(this.zipFileFolder);
                this.percentComplete = 100;
                return;
            }
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "There were no files found in the zip file selected.\nEnsure you selected the zip file exported by\nyour test generator and please try again?", "File Not Found", 0);
            boolean dirDelete = FileUtilities.removeDirectory(this.zipFileFolder);
            this.percentComplete = 100;
            return;
        }
        for (int z = 0; z < this.inputFiles.size(); ++z) {
            try {
                boolean badFile = false;
                this.inFile = new File(this.inputFiles.get(z));
                this.inFileStream = new FileInputStream(this.inFile);
                this.xmlInFile = new InputStreamReader((InputStream)this.inFileStream, "UTF8");
                Builder builder = new Builder();
                Document doc = builder.build((Reader)this.xmlInFile);
                Element root = doc.getRootElement();
                String title = "";
                try {
                    title = root.getFirstChildElement("assessment").getAttributeValue("title");
                }
                catch (NullPointerException ex) {
                    badFile = true;
                }
                if (badFile) continue;
                this.outFile = new File(outFileName);
                this.outFileStream = new FileOutputStream(this.outFile);
                this.xmlOutFile = new OutputStreamWriter((OutputStream)this.outFileStream, "UTF8");
                Elements questions = root.getFirstChildElement("assessment").getFirstChildElement("section").getChildElements("item");
                for (int i = 0; i < questions.size(); ++i) {
                    boolean single = true;
                    Element questionElement = questions.get(i);
                    String questionType = questionElement.getFirstChildElement("itemmetadata").getFirstChildElement("bbmd_questiontype").getValue();
                    if (questionType.equals("Multiple Choice") || questionType.equals("Multiple Answer") || questionType.equals("Matching") || questionType.equals("True/False") || questionType.equals("Fill in the Blank") || questionType.equals("Short Response") || questionType.equals("Numeric") || questionType.equals("Essay")) {
                        String[] tokens;
                        if (questionType.equals("Multiple Answer")) {
                            single = false;
                        }
                        float points = 1.0f;
                        String[] tolerance = new String[]{};
                        String questionFile = "";
                        String questionFileImageData = "";
                        String questionLink = "";
                        String itemFeedbackLink = "";
                        String[] itemFeedbackFile = new String[]{};
                        String[] itemFeedbackImageData = new String[]{};
                        String correctFeedbackFile = "";
                        String correctFeedbackImageData = "";
                        String correctFeedbackLink = "";
                        String incorrectFeedbackFile = "";
                        String incorrectFeedbackImageData = "";
                        String incorrectFeedbackLink = "";
                        String[] answer = new String[]{};
                        String[] answerID = new String[]{};
                        ArrayList choicesLabel = new ArrayList();
                        String answerLink = "";
                        String[] answerFile = new String[]{};
                        String[] answerFileImageData = new String[]{};
                        String[] choice = new String[]{};
                        String[] graderinfo = new String[]{};
                        String name = "";
                        String[] itemFeedback = new String[]{};
                        ArrayList<List> itemFeedbackImageInfo = new ArrayList<List>();
                        String correctFeedback = "";
                        ArrayList<List> correctFeedbackImageInfo = new ArrayList<List>();
                        String incorrectFeedback = "";
                        ArrayList<List> incorrectFeedbackImageInfo = new ArrayList<List>();
                        String generalFeedback = "";
                        ArrayList generalFeedbackImageInfo = new ArrayList();
                        String questionText = "";
                        List<Object> questionImageInfo = new ArrayList();
                        ArrayList<List> answerImageInfo = new ArrayList<List>();
                        ArrayList<List> graderinfoImageInfo = new ArrayList<List>();
                        String[] fraction = new String[]{};
                        Regex r = new Regex();
                        try {
                            Elements questionFileElements = questionElement.getFirstChildElement("presentation").getFirstChildElement("flow").getFirstChildElement("flow").getChildElements("flow");
                            for (int j = 0; j < questionFileElements.size(); ++j) {
                                Element questionFileElement = questionFileElements.get(j);
                                if (questionFileElement.getAttributeValue("class").equals("FORMATTED_TEXT_BLOCK")) {
                                    try {
                                        questionText = questionFileElement.getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                        r = new Regex("(?i)<img ");
                                        r.search(questionText);
                                        if (r.didMatch()) {
                                            questionImageInfo = ConverterUtilities.convertImage(questionText, 0, fileList, rootDir);
                                        }
                                        questionText = ConverterUtilities.convertImageTags(questionText);
                                    }
                                    catch (NullPointerException ex) {
                                        questionText = "";
                                    }
                                    continue;
                                }
                                if (questionFileElement.getAttributeValue("class").equals("FILE_BLOCK")) {
                                    questionFile = questionFileElement.getFirstChildElement("material").getFirstChildElement("matapplication").getAttributeValue("uri");
                                    if (questionFile.equals("")) continue;
                                    String[] tokens2 = questionFile.split("/");
                                    questionFile = tokens2[tokens2.length - 1];
                                    StringBuilder file = new StringBuilder("<br><img src=\"@@PLUGINFILE@@/");
                                    file.append(tokens2[tokens2.length - 1]);
                                    file.append("\">");
                                    questionText = questionText + file.toString();
                                    if (tokens2.length <= 1) continue;
                                    Regex r3 = new Regex(FileUtilities.convert(tokens2[tokens2.length - 2]));
                                    r3.setIgnoreCase(true);
                                    StringBuilder imagePath = new StringBuilder(FileUtilities.findDir(rootDir, r3, fileList));
                                    if (imagePath.toString().equals("")) continue;
                                    imagePath.append("\\");
                                    imagePath.append(tokens2[tokens2.length - 1]);
                                    questionFileImageData = ConverterUtilities.convert2Base64(imagePath.toString());
                                    continue;
                                }
                                if (questionFileElement.getAttributeValue("class").equals("LINK_BLOCK")) {
                                    questionLink = questionFileElement.getFirstChildElement("material").getFirstChildElement("mattext").getAttributeValue("uri");
                                    if (questionLink.equals("")) continue;
                                    StringBuilder link = new StringBuilder("<br><img src=\"");
                                    link.append(questionLink);
                                    link.append("\">");
                                    questionText = questionText + link.toString();
                                    continue;
                                }
                                if (questionFile == null) {
                                    questionFile = "";
                                }
                                questionFileImageData = "";
                                if (questionLink != null) continue;
                                questionLink = "";
                            }
                        }
                        catch (NullPointerException ex) {
                            // empty catch block
                        }
                        questionText = ConverterUtilities.cleanHTML(questionText);
                        StringBuilder appendName = new StringBuilder(namePrefix.trim());
                        if (!appendName.toString().equals("")) {
                            appendName.append(" ");
                        }
                        appendName.append("q");
                        int len = String.valueOf(questions.size()).length();
                        String tempName = String.valueOf(i + 1);
                        len -= tempName.length();
                        for (int j = 0; j < len; ++j) {
                            appendName.append("0");
                        }
                        appendName.append(tempName);
                        appendName.append(" ");
                        appendName.append(ConverterUtilities.html2text(questionText));
                        name = appendName.length() > 80 ? appendName.toString().substring(0, 80) : appendName.toString();
                        Elements flow = questionElement.getFirstChildElement("presentation").getFirstChildElement("flow").getChildElements("flow");
                        for (int h = 0; h < flow.size(); ++h) {
                            int j;
                            Element flowElement = flow.get(h);
                            if (!(!flowElement.getAttributeValue("class").equals("RESPONSE_BLOCK") || questionType.equals("Essay") || questionType.equals("Fill in the Blank") || questionType.equals("Short Response") || questionType.equals("Numeric"))) {
                                Elements answerElements = questionType.equals("True/False") || questionType.equals("Either/Or") ? flowElement.getFirstChildElement("response_lid").getFirstChildElement("render_choice").getFirstChildElement("flow_label").getChildElements("response_label") : (questionType.equals("Matching") ? flowElement.getChildElements("flow") : flowElement.getFirstChildElement("response_lid").getFirstChildElement("render_choice").getChildElements("flow_label"));
                                fraction = (String[])ConverterUtilities.resizeArray(fraction, answerElements.size());
                                answer = (String[])ConverterUtilities.resizeArray(answer, answerElements.size());
                                answerID = (String[])ConverterUtilities.resizeArray(answerID, answerElements.size());
                                answerFile = (String[])ConverterUtilities.resizeArray(answerFile, answer.length);
                                answerFileImageData = (String[])ConverterUtilities.resizeArray(answerFileImageData, answer.length);
                                for (j = 0; j < answerElements.size(); ++j) {
                                    if (questionType.equals("True/False")) {
                                        answer[j] = answerElements.get(j).getFirstChildElement("flow_mat").getFirstChildElement("material").getFirstChildElement("mattext").getValue();
                                    } else if (questionType.equals("Either/Or")) {
                                        answer[j] = answerElements.get(j).getFirstChildElement("flow_mat").getFirstChildElement("material").getFirstChildElement("mattext").getValue();
                                        if (answer[j].equals("yes_no.true")) {
                                            answer[j] = "yes";
                                            answerID[j] = "yes_no.true";
                                        } else if (answer[j].equals("yes_no.false")) {
                                            answer[j] = "no";
                                            answerID[j] = "yes_no.false";
                                        } else if (answer[j].equals("agree_disagree.true")) {
                                            answer[j] = "agree";
                                            answerID[j] = "agree_disagree.true";
                                        } else if (answer[j].equals("agree_disagree.false")) {
                                            answer[j] = "disagree";
                                            answerID[j] = "agree_disagree.false";
                                        } else if (answer[j].equals("right_wrong.true")) {
                                            answer[j] = "right";
                                            answerID[j] = "right_wrong.true";
                                        } else if (answer[j].equals("right_wrong.false")) {
                                            answer[j] = "wrong";
                                            answerID[j] = "right_wrong.false";
                                        } else if (answer[j].equals("true_false.true")) {
                                            answer[j] = "true";
                                            answerID[j] = "true_false.true";
                                        } else if (answer[j].equals("true_false.false")) {
                                            answer[j] = "false";
                                            answerID[j] = "true_false.false";
                                        }
                                    } else if (questionType.equals("Matching")) {
                                        Elements flow_match = answerElements.get(j).getChildElements("flow");
                                        answerID[j] = answerElements.get(j).getFirstChildElement("response_lid").getAttributeValue("ident");
                                        Elements response_label = answerElements.get(j).getFirstChildElement("response_lid").getFirstChildElement("render_choice").getFirstChildElement("flow_label").getChildElements("response_label");
                                        ArrayList<String> responseLabel = new ArrayList<String>();
                                        for (int b = 0; b < response_label.size(); ++b) {
                                            responseLabel.add(response_label.get(b).getAttributeValue("ident"));
                                        }
                                        choicesLabel.add(responseLabel);
                                        for (int f = 0; f < flow_match.size(); ++f) {
                                            try {
                                                if (flow_match.get(f).getAttributeValue("class").equals("FORMATTED_TEXT_BLOCK")) {
                                                    answer[j] = flow_match.get(f).getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                                    continue;
                                                }
                                                if (flow_match.get(f).getAttributeValue("class").equals("FILE_BLOCK")) {
                                                    answerFile[j] = flow_match.get(f).getFirstChildElement("material").getFirstChildElement("matapplication").getAttributeValue("uri");
                                                    if (answerFile[j].equals("")) continue;
                                                    String[] tokens3 = answerFile[j].split("/");
                                                    answerFile[j] = tokens3[tokens3.length - 1];
                                                    StringBuilder file = new StringBuilder("<br><img src=\"@@PLUGINFILE@@/");
                                                    file.append(tokens3[tokens3.length - 1]);
                                                    file.append("\">");
                                                    answer[j] = answer[j] + file.toString();
                                                    if (tokens3.length <= 1) continue;
                                                    Regex r3 = new Regex(FileUtilities.convert(tokens3[tokens3.length - 2]));
                                                    r3.setIgnoreCase(true);
                                                    StringBuilder imagePath = new StringBuilder(FileUtilities.findDir(rootDir, r3, fileList));
                                                    if (imagePath.toString().equals("")) continue;
                                                    imagePath.append("\\");
                                                    imagePath.append(tokens3[tokens3.length - 1]);
                                                    answerFileImageData[j] = ConverterUtilities.convert2Base64(imagePath.toString());
                                                    continue;
                                                }
                                                if (!flow_match.get(f).getAttributeValue("class").equals("LINK_BLOCK") || (answerLink = flow_match.get(f).getFirstChildElement("material").getFirstChildElement("mattext").getAttributeValue("uri")).equals("")) continue;
                                                StringBuilder link = new StringBuilder("<br><img src=\"");
                                                link.append(answerLink);
                                                link.append("\">");
                                                answer[j] = answer[j] + link.toString();
                                                continue;
                                            }
                                            catch (NullPointerException ex) {
                                                // empty catch block
                                            }
                                        }
                                    } else {
                                        Elements flow_mat = answerElements.get(j).getFirstChildElement("response_label").getChildElements("flow_mat");
                                        for (int g = 0; g < flow_mat.size(); ++g) {
                                            try {
                                                if (flow_mat.get(g).getAttributeValue("class").equals("FORMATTED_TEXT_BLOCK")) {
                                                    answer[j] = flow_mat.get(g).getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                                    r.search(answer[j]);
                                                    if (!r.didMatch()) continue;
                                                    answerImageInfo.add(ConverterUtilities.convertImage(answer[j], j, fileList, rootDir));
                                                    answer[j] = ConverterUtilities.convertImageTags(answer[j]);
                                                    continue;
                                                }
                                                if (flow_mat.get(g).getAttributeValue("class").equals("FILE_BLOCK")) {
                                                    answerFile[j] = flow_mat.get(g).getFirstChildElement("material").getFirstChildElement("matapplication").getAttributeValue("uri");
                                                    String[] tokens4 = answerFile[j].split("/");
                                                    answerFile[j] = tokens4[tokens4.length - 1];
                                                    if (answerFile[j].equals("")) continue;
                                                    StringBuilder file = new StringBuilder("<br><img src=\"@@PLUGINFILE@@/");
                                                    file.append(tokens4[tokens4.length - 1]);
                                                    file.append("\">");
                                                    answer[j] = answer[j] + file.toString();
                                                    if (tokens4.length <= 1) continue;
                                                    Regex r3 = new Regex(FileUtilities.convert(tokens4[tokens4.length - 2]));
                                                    r3.setIgnoreCase(true);
                                                    StringBuilder imagePath = new StringBuilder(FileUtilities.findDir(rootDir, r3, fileList));
                                                    if (imagePath.toString().equals("")) continue;
                                                    imagePath.append("\\");
                                                    imagePath.append(tokens4[tokens4.length - 1]);
                                                    answerFileImageData[j] = ConverterUtilities.convert2Base64(imagePath.toString());
                                                    continue;
                                                }
                                                if (!flow_mat.get(g).getAttributeValue("class").equals("LINK_BLOCK") || (answerLink = flow_mat.get(g).getFirstChildElement("material").getFirstChildElement("mattext").getAttributeValue("uri")).equals("")) continue;
                                                StringBuilder link = new StringBuilder("<br><img src=\"");
                                                link.append(answerLink);
                                                link.append("\">");
                                                answer[j] = answer[j] + link.toString();
                                                continue;
                                            }
                                            catch (NullPointerException ex) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    answer[j] = ConverterUtilities.cleanHTML(answer[j]);
                                    if (questionType.equals("True/False")) {
                                        answerID[j] = answerElements.get(j).getAttributeValue("ident");
                                        continue;
                                    }
                                    if (questionType.equals("Matching") || questionType.equals("Either/Or")) continue;
                                    answerID[j] = answerElements.get(j).getFirstChildElement("response_label").getAttributeValue("ident");
                                }
                            }
                            if (questionType.equals("Matching") && flowElement.getAttributeValue("class").equals("RIGHT_MATCH_BLOCK")) {
                                int j2;
                                Elements choiceElements = flowElement.getChildElements("flow");
                                choice = (String[])ConverterUtilities.resizeArray(choice, choiceElements.size());
                                for (j2 = 0; j2 < choiceElements.size(); ++j2) {
                                    choice[j2] = choiceElements.get(j2).getFirstChildElement("flow").getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                    choice[j2] = ConverterUtilities.html2text(choice[j2]);
                                }
                                if (choice.length > answer.length) {
                                    answer = (String[])ConverterUtilities.resizeArray(answer, choice.length);
                                    answerFile = (String[])ConverterUtilities.resizeArray(answerFile, choice.length);
                                    answerFileImageData = (String[])ConverterUtilities.resizeArray(answerFileImageData, choice.length);
                                    for (j2 = 0; j2 < answer.length; ++j2) {
                                        if (answer[j2] != null) continue;
                                        answer[j2] = "";
                                    }
                                }
                            }
                            for (j = 0; j < answerFile.length; ++j) {
                                if (answerFile[j] != null) continue;
                                answerFile[j] = "";
                                answerFileImageData[j] = "";
                            }
                        }
                        try {
                            points = Float.valueOf(questionElement.getFirstChildElement("resprocessing").getFirstChildElement("outcomes").getFirstChildElement("decvar").getAttributeValue("maxvalue")).floatValue();
                        }
                        catch (NullPointerException ex) {
                            points = 1.0f;
                        }
                        Elements respcondition = questionElement.getFirstChildElement("resprocessing").getChildElements("respcondition");
                        String[][] matchAnswerID = new String[0][2];
                        for (int j = 0; j < respcondition.size(); ++j) {
                            Element respconditionElement = respcondition.get(j);
                            try {
                                String answerNum = "answer_" + String.valueOf(j + 1);
                                String respconditionTitle = "";
                                try {
                                    respconditionTitle = respconditionElement.getAttributeValue("title");
                                    if (respconditionTitle == null) {
                                        respconditionTitle = "";
                                    }
                                }
                                catch (Exception ex) {
                                    respconditionTitle = "";
                                }
                                if (respconditionTitle.equals("correct")) {
                                    if (single && !questionType.equals("Fill in the Blank")) {
                                        String correctAnswerID = respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("varequal").getValue();
                                        for (int k = 0; k < answerID.length; ++k) {
                                            if (questionType.equals("True/False")) {
                                                if (answer[k].equals(correctAnswerID)) {
                                                    fraction[k] = "100.0";
                                                    continue;
                                                }
                                                fraction[k] = "0.0";
                                                continue;
                                            }
                                            fraction[k] = answerID[k].equals(correctAnswerID) ? "100.0" : "0.0";
                                        }
                                        continue;
                                    }
                                    if (single || !questionType.equals("Multiple Answer")) continue;
                                    Elements answers = respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("and").getChildElements();
                                    Elements correctAnswers = respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("and").getChildElements("varequal");
                                    for (int k = 0; k < answers.size(); ++k) {
                                        for (int x = 0; x < answerID.length; ++x) {
                                            if (answers.get(x).getLocalName().equals("not")) {
                                                fraction[k] = "0.0";
                                                continue;
                                            }
                                            if (!answers.get(x).getLocalName().equals("varequal")) continue;
                                            fraction[x] = String.valueOf(ConverterUtilities.roundTwoDecimals(100.0f / (float)correctAnswers.size()));
                                        }
                                    }
                                    continue;
                                }
                                if (respconditionTitle.equals(answerNum) || (questionType.equals("Numeric") || questionType.equals("Fill in the Blank")) && !respconditionTitle.equals("incorrect")) {
                                    fraction = (String[])ConverterUtilities.resizeArray(fraction, fraction.length + 1);
                                    answer = (String[])ConverterUtilities.resizeArray(answer, answer.length + 1);
                                    answer[answer.length - 1] = respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("varequal").getValue();
                                    r.search(answer[answer.length - 1]);
                                    if (r.didMatch()) {
                                        answerImageInfo.add(ConverterUtilities.convertImage(answer[answer.length - 1], answer.length - 1, fileList, rootDir));
                                        answer[answer.length - 1] = ConverterUtilities.convertImageTags(answer[answer.length - 1]);
                                    }
                                    if (questionType.equals("Numeric")) {
                                        try {
                                            tolerance = (String[])ConverterUtilities.resizeArray(tolerance, tolerance.length + 1);
                                            double vargte = Double.valueOf(respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("vargte").getValue());
                                            double varlte = Double.valueOf(respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("varlte").getValue());
                                            int numPlaces = 0;
                                            r = new Regex("\\.");
                                            r.search(String.valueOf(varlte));
                                            if (r.didMatch()) {
                                                tokens = String.valueOf(varlte).split("\\.");
                                                numPlaces = tokens[tokens.length - 1].length();
                                            }
                                            tolerance[tolerance.length - 1] = String.valueOf(ConverterUtilities.round((varlte - vargte) / 2.0, numPlaces));
                                        }
                                        catch (NullPointerException ex) {
                                            tolerance[tolerance.length - 1] = "0.0";
                                        }
                                    }
                                    fraction[fraction.length - 1] = "100.0";
                                    continue;
                                }
                                if (!questionType.equals("Matching") || respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("varequal").getValue().equals("")) continue;
                                matchAnswerID = (String[][])ConverterUtilities.resizeArray(matchAnswerID, matchAnswerID.length + 1);
                                for (int a = 0; a < matchAnswerID.length; ++a) {
                                    matchAnswerID[a] = matchAnswerID[a] == null ? new String[2] : (String[])ConverterUtilities.resizeArray(matchAnswerID[a], 2);
                                }
                                matchAnswerID[j][0] = respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("varequal").getAttributeValue("respident");
                                matchAnswerID[j][1] = respconditionElement.getFirstChildElement("conditionvar").getFirstChildElement("varequal").getValue();
                                continue;
                            }
                            catch (NullPointerException ex) {
                                // empty catch block
                            }
                        }
                        String[] tempChoice = new String[matchAnswerID.length];
                        if (choice.length > tempChoice.length) {
                            tempChoice = (String[])ConverterUtilities.resizeArray(tempChoice, choice.length);
                        }
                        for (int b = 0; b < matchAnswerID.length; ++b) {
                            for (int c = 0; c < answerID.length; ++c) {
                                if (matchAnswerID[b][0] == null || !matchAnswerID[b][0].equals(answerID[c])) continue;
                                for (int d = 0; d < choicesLabel.size(); ++d) {
                                    for (int e = 0; e < ((List)choicesLabel.get(d)).size(); ++e) {
                                        String tempChoiceLabel = (String)((List)choicesLabel.get(d)).get(e);
                                        if (!matchAnswerID[b][1].equals(tempChoiceLabel)) continue;
                                        tempChoice[b] = choice[e];
                                    }
                                }
                            }
                        }
                        int position = tempChoice.length - 1;
                        for (int p = 0; p < choice.length; ++p) {
                            boolean choiceFound = false;
                            for (int q = 0; q < tempChoice.length; ++q) {
                                if (!choice[p].equals(tempChoice[q])) continue;
                                choiceFound = true;
                            }
                            if (choiceFound) continue;
                            tempChoice[position] = choice[p];
                            --position;
                        }
                        if (choice.length < tempChoice.length) {
                            choice = (String[])ConverterUtilities.resizeArray(choice, tempChoice.length);
                        }
                        choice = tempChoice;
                        Elements itemfeedback = questionElement.getChildElements("itemfeedback");
                        itemFeedback = (String[])ConverterUtilities.resizeArray(itemFeedback, answerID.length);
                        itemFeedbackFile = (String[])ConverterUtilities.resizeArray(itemFeedbackFile, answerID.length);
                        itemFeedbackImageData = (String[])ConverterUtilities.resizeArray(itemFeedbackImageData, answerID.length);
                        for (int j = 0; j < itemfeedback.size(); ++j) {
                            Element itemfeedbackElement = itemfeedback.get(j);
                            for (int k = 0; k < answerID.length; ++k) {
                                if (!questionType.equals("Essay")) {
                                    if (itemFeedback[k] == null) {
                                        itemFeedback[k] = "";
                                    }
                                    try {
                                        if (answerID[k].equals(itemfeedbackElement.getAttributeValue("ident"))) {
                                            Elements flow_mat = itemfeedbackElement.getFirstChildElement("solution").getFirstChildElement("solutionmaterial").getFirstChildElement("flow_mat").getChildElements("flow_mat");
                                            for (int x = 0; x < flow_mat.size(); ++x) {
                                                if (flow_mat.get(x).getAttributeValue("class").equals("FORMATTED_TEXT_BLOCK")) {
                                                    itemFeedback[k] = flow_mat.get(x).getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                                    r.search(itemFeedback[k]);
                                                    if (!r.didMatch()) continue;
                                                    itemFeedbackImageInfo.add(ConverterUtilities.convertImage(itemFeedback[k], k, fileList, rootDir));
                                                    itemFeedback[k] = ConverterUtilities.convertImageTags(itemFeedback[k]);
                                                    continue;
                                                }
                                                if (flow_mat.get(x).getAttributeValue("class").equals("FILE_BLOCK")) {
                                                    itemFeedbackFile[k] = flow_mat.get(x).getFirstChildElement("material").getFirstChildElement("matapplication").getAttributeValue("uri");
                                                    if (itemFeedbackFile[k].equals("")) continue;
                                                    tokens = itemFeedbackFile[k].split("/");
                                                    itemFeedbackFile[k] = tokens[tokens.length - 1];
                                                    StringBuilder file = new StringBuilder("<br><img src=\"@@PLUGINFILE@@/");
                                                    file.append(tokens[tokens.length - 1]);
                                                    file.append("\">");
                                                    itemFeedback[k] = itemFeedback[k] + file.toString();
                                                    if (tokens.length <= 1) continue;
                                                    Regex r3 = new Regex(FileUtilities.convert(tokens[tokens.length - 2]));
                                                    r3.setIgnoreCase(true);
                                                    StringBuilder imagePath = new StringBuilder(FileUtilities.findDir(rootDir, r3, fileList));
                                                    if (imagePath.toString().equals("")) continue;
                                                    imagePath.append("\\");
                                                    imagePath.append(tokens[tokens.length - 1]);
                                                    itemFeedbackImageData[k] = ConverterUtilities.convert2Base64(imagePath.toString());
                                                    continue;
                                                }
                                                if (!flow_mat.get(x).getAttributeValue("class").equals("LINK_BLOCK") || (itemFeedbackLink = flow_mat.get(x).getFirstChildElement("material").getFirstChildElement("mattext").getAttributeValue("uri")).equals("")) continue;
                                                StringBuilder link = new StringBuilder("<br><img src=\"");
                                                link.append(itemFeedbackLink);
                                                link.append("\">");
                                                itemFeedback[k] = itemFeedback[k] + link.toString();
                                            }
                                        }
                                    }
                                    catch (NullPointerException ex) {
                                        // empty catch block
                                    }
                                }
                                itemFeedback[k] = ConverterUtilities.cleanHTML(itemFeedback[k]);
                            }
                            try {
                                StringBuilder imagePath;
                                Regex r3;
                                StringBuilder file;
                                if (itemfeedbackElement.getAttributeValue("ident").equals("correct")) {
                                    Elements flow_mat = itemfeedbackElement.getFirstChildElement("flow_mat").getChildElements("flow_mat");
                                    for (int k = 0; k < flow_mat.size(); ++k) {
                                        if (flow_mat.get(k).getAttributeValue("class").equals("FORMATTED_TEXT_BLOCK")) {
                                            correctFeedback = flow_mat.get(k).getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                            r.search(correctFeedback);
                                            if (r.didMatch()) {
                                                correctFeedbackImageInfo.add(ConverterUtilities.convertImage(correctFeedback, 0, fileList, rootDir));
                                                correctFeedback = ConverterUtilities.convertImageTags(correctFeedback);
                                            }
                                        } else if (flow_mat.get(k).getAttributeValue("class").equals("FILE_BLOCK")) {
                                            correctFeedbackFile = flow_mat.get(k).getFirstChildElement("material").getFirstChildElement("matapplication").getAttributeValue("uri");
                                            if (!correctFeedbackFile.equals("")) {
                                                String[] tokens5 = correctFeedbackFile.split("/");
                                                correctFeedbackFile = tokens5[tokens5.length - 1];
                                                file = new StringBuilder("<br><img src=\"@@PLUGINFILE@@/");
                                                file.append(tokens5[tokens5.length - 1]);
                                                file.append("\">");
                                                correctFeedback = correctFeedback + file.toString();
                                                if (tokens5.length > 1) {
                                                    r3 = new Regex(FileUtilities.convert(tokens5[tokens5.length - 2]));
                                                    r3.setIgnoreCase(true);
                                                    imagePath = new StringBuilder(FileUtilities.findDir(rootDir, r3, fileList));
                                                    if (!imagePath.toString().equals("")) {
                                                        imagePath.append("\\");
                                                        imagePath.append(tokens5[tokens5.length - 1]);
                                                        correctFeedbackImageData = ConverterUtilities.convert2Base64(imagePath.toString());
                                                    }
                                                }
                                            }
                                        } else if (flow_mat.get(k).getAttributeValue("class").equals("LINK_BLOCK")) {
                                            correctFeedbackLink = flow_mat.get(k).getFirstChildElement("material").getFirstChildElement("mattext").getAttributeValue("uri");
                                            if (!correctFeedbackLink.equals("")) {
                                                StringBuilder link = new StringBuilder("<br><img src=\"");
                                                link.append(correctFeedbackLink);
                                                link.append("\">");
                                                correctFeedback = correctFeedback + link.toString();
                                            }
                                        } else {
                                            if (correctFeedbackFile == null) {
                                                correctFeedbackFile = "";
                                            }
                                            correctFeedbackImageData = "";
                                            if (correctFeedbackLink == null) {
                                                correctFeedbackLink = "";
                                            }
                                        }
                                        correctFeedback = ConverterUtilities.cleanHTML(correctFeedback);
                                    }
                                } else if (itemfeedbackElement.getAttributeValue("ident").equals("incorrect")) {
                                    Elements flow_mat = itemfeedbackElement.getFirstChildElement("flow_mat").getChildElements("flow_mat");
                                    for (int k = 0; k < flow_mat.size(); ++k) {
                                        if (flow_mat.get(k).getAttributeValue("class").equals("FORMATTED_TEXT_BLOCK")) {
                                            incorrectFeedback = flow_mat.get(k).getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                            r.search(incorrectFeedback);
                                            if (!r.didMatch()) continue;
                                            incorrectFeedbackImageInfo.add(ConverterUtilities.convertImage(incorrectFeedback, 0, fileList, rootDir));
                                            incorrectFeedback = ConverterUtilities.convertImageTags(incorrectFeedback);
                                            continue;
                                        }
                                        if (flow_mat.get(k).getAttributeValue("class").equals("FILE_BLOCK")) {
                                            incorrectFeedbackFile = flow_mat.get(k).getFirstChildElement("material").getFirstChildElement("matapplication").getAttributeValue("uri");
                                            if (incorrectFeedbackFile.equals("")) continue;
                                            String[] tokens6 = incorrectFeedbackFile.split("/");
                                            incorrectFeedbackFile = tokens6[tokens6.length - 1];
                                            file = new StringBuilder("<br><img src=\"@@PLUGINFILE@@/");
                                            file.append(tokens6[tokens6.length - 1]);
                                            file.append("\">");
                                            incorrectFeedback = incorrectFeedback + file.toString();
                                            if (tokens6.length <= 1) continue;
                                            r3 = new Regex(FileUtilities.convert(tokens6[tokens6.length - 2]));
                                            r3.setIgnoreCase(true);
                                            imagePath = new StringBuilder(FileUtilities.findDir(rootDir, r3, fileList));
                                            if (imagePath.toString().equals("")) continue;
                                            imagePath.append("\\");
                                            imagePath.append(tokens6[tokens6.length - 1]);
                                            incorrectFeedbackImageData = ConverterUtilities.convert2Base64(imagePath.toString());
                                            continue;
                                        }
                                        if (flow_mat.get(k).getAttributeValue("class").equals("LINK_BLOCK")) {
                                            incorrectFeedbackLink = flow_mat.get(k).getFirstChildElement("material").getFirstChildElement("mattext").getAttributeValue("uri");
                                            if (incorrectFeedbackLink.equals("")) continue;
                                            StringBuilder link = new StringBuilder("<br><img src=\"");
                                            link.append(incorrectFeedbackLink);
                                            link.append("\">");
                                            incorrectFeedback = incorrectFeedback + link.toString();
                                            continue;
                                        }
                                        if (incorrectFeedbackFile == null) {
                                            incorrectFeedbackFile = "";
                                        }
                                        incorrectFeedbackImageData = "";
                                        if (incorrectFeedbackLink != null) continue;
                                        incorrectFeedbackLink = "";
                                    }
                                    incorrectFeedback = ConverterUtilities.cleanHTML(incorrectFeedback);
                                } else if (itemfeedbackElement.getAttributeValue("ident").equals("solution")) {
                                    if (questionType.equals("Essay")) {
                                        graderinfo = (String[])ConverterUtilities.resizeArray(graderinfo, graderinfo.length + 1);
                                        graderinfo[0] = itemfeedbackElement.getFirstChildElement("solution").getFirstChildElement("solutionmaterial").getFirstChildElement("flow_mat").getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                        r.search(graderinfo[0]);
                                        if (r.didMatch()) {
                                            graderinfoImageInfo.add(ConverterUtilities.convertImage(graderinfo[0], 0, fileList, rootDir));
                                            graderinfo[0] = ConverterUtilities.convertImageTags(graderinfo[0]);
                                        }
                                    } else if (questionType.equals("Short Response")) {
                                        answer = (String[])ConverterUtilities.resizeArray(answer, answer.length + 1);
                                        fraction = (String[])ConverterUtilities.resizeArray(fraction, fraction.length + 1);
                                        fraction[0] = "100.0";
                                        answer[0] = itemfeedbackElement.getFirstChildElement("solution").getFirstChildElement("solutionmaterial").getFirstChildElement("flow_mat").getFirstChildElement("material").getFirstChildElement("mat_extension").getFirstChildElement("mat_formattedtext").getValue();
                                        r.search(answer[0]);
                                        if (r.didMatch()) {
                                            answerImageInfo.add(ConverterUtilities.convertImage(answer[0], 0, fileList, rootDir));
                                            answer[0] = ConverterUtilities.convertImageTags(answer[0]);
                                        }
                                        answer[0] = ConverterUtilities.cleanHTML(answer[0]);
                                    }
                                }
                            }
                            catch (NullPointerException ex) {
                                // empty catch block
                            }
                            for (int k = 0; k < itemFeedbackFile.length; ++k) {
                                if (itemFeedbackFile[k] != null) continue;
                                itemFeedbackFile[k] = "";
                                itemFeedbackImageData[k] = "";
                            }
                        }
                        if (questionType.equals("Multiple Choice") || questionType.equals("Multiple Answer") || questionType.equals("Either/Or")) {
                            MultiChoice questionBuilder = new MultiChoice();
                            questionBuilder.name = name;
                            questionBuilder.questiontext = questionText;
                            if (questionImageInfo.size() > 0) {
                                questionBuilder.questionImageList = questionImageInfo;
                            }
                            questionBuilder.questionfile = questionFile;
                            questionBuilder.questionfileBase64 = questionFileImageData;
                            questionBuilder.generalfeedback = generalFeedback;
                            if (generalFeedbackImageInfo.size() > 0) {
                                questionBuilder.generalfeedbackImageList = generalFeedbackImageInfo;
                            }
                            questionBuilder.correctfeedback = correctFeedback;
                            if (correctFeedbackImageInfo.size() > 0) {
                                questionBuilder.correctfeedbackImageList = correctFeedbackImageInfo;
                            }
                            questionBuilder.correctfeedbackFile = correctFeedbackFile;
                            questionBuilder.correctfeedbackFileBase64 = correctFeedbackImageData;
                            questionBuilder.incorrectfeedback = incorrectFeedback;
                            if (incorrectFeedbackImageInfo.size() > 0) {
                                questionBuilder.incorrectfeedbackImageList = incorrectFeedbackImageInfo;
                            }
                            questionBuilder.incorrectfeedbackFile = incorrectFeedbackFile;
                            questionBuilder.incorrectfeedbackFileBase64 = incorrectFeedbackImageData;
                            questionBuilder.answer = Arrays.asList(answer);
                            questionBuilder.fraction = Arrays.asList(fraction);
                            if (answerImageInfo.size() > 0) {
                                questionBuilder.answerImageList = answerImageInfo;
                            }
                            questionBuilder.answerfile = Arrays.asList(answerFile);
                            questionBuilder.answerfileBase64 = Arrays.asList(answerFileImageData);
                            questionBuilder.feedback = Arrays.asList(itemFeedback);
                            if (itemFeedbackImageInfo.size() > 0) {
                                questionBuilder.feedbackImageList = itemFeedbackImageInfo;
                            }
                            questionBuilder.feedbackfile = Arrays.asList(itemFeedbackFile);
                            questionBuilder.feedbackfileBase64 = Arrays.asList(itemFeedbackImageData);
                            questionBuilder.penalty = 0.33f;
                            questionBuilder.shuffleanswers = 0;
                            try {
                                questionBuilder.defaultgrade = points;
                            }
                            catch (NullPointerException ex) {
                                questionBuilder.defaultgrade = 1.0f;
                            }
                            questionBuilder.single = single;
                            if (!headerPresent) {
                                questionXML.append((CharSequence)MultiChoice.buildXMLHeader(title));
                                headerPresent = true;
                            }
                            questionXML.append((CharSequence)questionBuilder.multiChoiceXML(questionBuilder));
                            this.xmlOutFile.write(questionXML.toString());
                            questionXML.delete(0, questionXML.length() - 1);
                        } else if (questionType.equals("Matching")) {
                            Matching questionBuilder = new Matching();
                            questionBuilder.name = name;
                            questionBuilder.questiontext = questionText;
                            if (questionImageInfo.size() > 0) {
                                questionBuilder.questionImageList = questionImageInfo;
                            }
                            questionBuilder.questionfile = questionFile;
                            questionBuilder.questionfileBase64 = questionFileImageData;
                            questionBuilder.generalfeedback = generalFeedback;
                            if (generalFeedbackImageInfo.size() > 0) {
                                questionBuilder.generalfeedbackImageList = generalFeedbackImageInfo;
                            }
                            questionBuilder.subquestion = Arrays.asList(answer);
                            if (answerImageInfo.size() > 0) {
                                questionBuilder.subquestionImageList = answerImageInfo;
                            }
                            questionBuilder.subquestionfile = Arrays.asList(answerFile);
                            questionBuilder.subquestionfileBase64 = Arrays.asList(answerFileImageData);
                            questionBuilder.answer = Arrays.asList(choice);
                            questionBuilder.penalty = 0.33f;
                            questionBuilder.shuffleanswers = 1;
                            try {
                                questionBuilder.defaultgrade = points;
                            }
                            catch (NullPointerException ex) {
                                questionBuilder.defaultgrade = 1.0f;
                            }
                            if (!headerPresent) {
                                questionXML.append((CharSequence)Matching.buildXMLHeader(title));
                                headerPresent = true;
                            }
                            questionXML.append((CharSequence)questionBuilder.matchingXML(questionBuilder));
                            this.xmlOutFile.write(questionXML.toString());
                            questionXML.delete(0, questionXML.length() - 1);
                        } else if (questionType.equals("True/False")) {
                            TrueFalse questionBuilder = new TrueFalse();
                            questionBuilder.name = name;
                            questionBuilder.questiontext = questionText;
                            if (questionImageInfo.size() > 0) {
                                questionBuilder.questionImageList = questionImageInfo;
                            }
                            questionBuilder.questionfile = questionFile;
                            questionBuilder.questionfileBase64 = questionFileImageData;
                            questionBuilder.correctfeedback = correctFeedback;
                            if (correctFeedbackImageInfo.size() > 0) {
                                questionBuilder.correctfeedbackImageList = correctFeedbackImageInfo;
                            }
                            r = new Regex("(?i)correct");
                            questionBuilder.generalfeedback = correctFeedback = r.replaceAllRegion(correctFeedback, 0, 7).trim();
                            if (correctFeedbackImageInfo.size() > 0) {
                                questionBuilder.generalfeedbackImageList = correctFeedbackImageInfo;
                            }
                            questionBuilder.incorrectfeedback = incorrectFeedback;
                            if (incorrectFeedbackImageInfo.size() > 0) {
                                questionBuilder.incorrectfeedbackImageList = incorrectFeedbackImageInfo;
                            }
                            for (int j = 0; j < answer.length; ++j) {
                                if (answer[j].toLowerCase(Locale.US).equals("yes")) {
                                    answer[j] = "true";
                                }
                                if (!answer[j].toLowerCase(Locale.US).equals("no")) continue;
                                answer[j] = "false";
                            }
                            questionBuilder.feedback = Arrays.asList(itemFeedback);
                            if (itemFeedbackImageInfo.size() > 0) {
                                questionBuilder.feedbackImageList = itemFeedbackImageInfo;
                            }
                            questionBuilder.feedbackfile = Arrays.asList(itemFeedbackFile);
                            questionBuilder.feedbackfileBase64 = Arrays.asList(itemFeedbackImageData);
                            questionBuilder.answer = Arrays.asList(answer);
                            questionBuilder.fraction = Arrays.asList(fraction);
                            questionBuilder.penalty = 1.0f;
                            questionBuilder.shuffleanswers = 0;
                            try {
                                questionBuilder.defaultgrade = points;
                            }
                            catch (NullPointerException ex) {
                                questionBuilder.defaultgrade = 1.0f;
                            }
                            if (!headerPresent) {
                                questionXML.append((CharSequence)TrueFalse.buildXMLHeader(title));
                                headerPresent = true;
                            }
                            questionXML.append((CharSequence)questionBuilder.trueFalseXML(questionBuilder));
                            this.xmlOutFile.write(questionXML.toString());
                            questionXML.delete(0, questionXML.length() - 1);
                        } else if (questionType.equals("Fill in the Blank") || questionType.equals("Short Response")) {
                            ShortAnswer questionBuilder = new ShortAnswer();
                            questionBuilder.name = name;
                            questionBuilder.questiontext = questionText;
                            if (questionImageInfo.size() > 0) {
                                questionBuilder.questionImageList = questionImageInfo;
                            }
                            questionBuilder.questionfile = questionFile;
                            questionBuilder.questionfileBase64 = questionFileImageData;
                            questionBuilder.generalfeedback = generalFeedback;
                            if (generalFeedbackImageInfo.size() > 0) {
                                questionBuilder.generalfeedbackImageList = generalFeedbackImageInfo;
                            }
                            questionBuilder.answer = Arrays.asList(answer);
                            questionBuilder.fraction = Arrays.asList(fraction);
                            questionBuilder.answerfile = Arrays.asList(answerFile);
                            questionBuilder.answerfileBase64 = Arrays.asList(answerFileImageData);
                            questionBuilder.feedback = Arrays.asList(itemFeedback);
                            if (itemFeedbackImageInfo.size() > 0) {
                                questionBuilder.feedbackImageList = itemFeedbackImageInfo;
                            }
                            questionBuilder.feedbackfile = Arrays.asList(itemFeedbackFile);
                            questionBuilder.feedbackfileBase64 = Arrays.asList(itemFeedbackImageData);
                            questionBuilder.penalty = 0.33f;
                            questionBuilder.shuffleanswers = 0;
                            try {
                                questionBuilder.defaultgrade = points;
                            }
                            catch (NullPointerException ex) {
                                questionBuilder.defaultgrade = 1.0f;
                            }
                            if (!headerPresent) {
                                questionXML.append((CharSequence)ShortAnswer.buildXMLHeader(title));
                                headerPresent = true;
                            }
                            questionXML.append((CharSequence)questionBuilder.shortAnswerXML(questionBuilder));
                            this.xmlOutFile.write(questionXML.toString());
                            questionXML.delete(0, questionXML.length() - 1);
                        } else if (questionType.equals("Numeric")) {
                            Numerical questionBuilder = new Numerical();
                            questionBuilder.name = name;
                            questionBuilder.questiontext = questionText;
                            if (questionImageInfo.size() > 0) {
                                questionBuilder.questionImageList = questionImageInfo;
                            }
                            questionBuilder.questionfile = questionFile;
                            questionBuilder.questionfileBase64 = questionFileImageData;
                            questionBuilder.generalfeedback = generalFeedback;
                            if (generalFeedbackImageInfo.size() > 0) {
                                questionBuilder.generalfeedbackImageList = generalFeedbackImageInfo;
                            }
                            questionBuilder.answer = Arrays.asList(answer);
                            questionBuilder.fraction = Arrays.asList(fraction);
                            questionBuilder.answerfile = Arrays.asList(answerFile);
                            questionBuilder.answerfileBase64 = Arrays.asList(answerFileImageData);
                            questionBuilder.tolerance = Arrays.asList(tolerance);
                            questionBuilder.feedback = Arrays.asList(itemFeedback);
                            if (itemFeedbackImageInfo.size() > 0) {
                                questionBuilder.feedbackImageList = itemFeedbackImageInfo;
                            }
                            questionBuilder.feedbackfile = Arrays.asList(itemFeedbackFile);
                            questionBuilder.feedbackfileBase64 = Arrays.asList(itemFeedbackImageData);
                            questionBuilder.penalty = 0.33f;
                            questionBuilder.shuffleanswers = 0;
                            try {
                                questionBuilder.defaultgrade = points;
                            }
                            catch (NullPointerException ex) {
                                questionBuilder.defaultgrade = 1.0f;
                            }
                            if (!headerPresent) {
                                questionXML.append((CharSequence)Numerical.buildXMLHeader(title));
                                headerPresent = true;
                            }
                            questionXML.append((CharSequence)questionBuilder.numericalXML(questionBuilder));
                            this.xmlOutFile.write(questionXML.toString());
                            questionXML.delete(0, questionXML.length() - 1);
                        } else if (questionType.equals("Essay")) {
                            Essay questionBuilder = new Essay();
                            questionBuilder.name = name;
                            questionBuilder.questiontext = questionText;
                            if (questionImageInfo.size() > 0) {
                                questionBuilder.questionImageList = questionImageInfo;
                            }
                            questionBuilder.questionfile = questionFile;
                            questionBuilder.questionfileBase64 = questionFileImageData;
                            questionBuilder.graderinfo = Arrays.asList(graderinfo);
                            if (graderinfoImageInfo.size() > 0) {
                                questionBuilder.graderinfoImageList = graderinfoImageInfo;
                            }
                            questionBuilder.penalty = 0.1f;
                            try {
                                questionBuilder.defaultgrade = points;
                            }
                            catch (NullPointerException ex) {
                                questionBuilder.defaultgrade = 1.0f;
                            }
                            if (!headerPresent) {
                                questionXML.append((CharSequence)Essay.buildXMLHeader(title));
                                headerPresent = true;
                            }
                            questionXML.append((CharSequence)questionBuilder.essayXML(questionBuilder));
                            this.xmlOutFile.write(questionXML.toString());
                            questionXML.delete(0, questionXML.length() - 1);
                        }
                    }
                    this.percentComplete = (int)Math.floor((double)(i + 1) / (double)questions.size() * 100.0);
                }
                Essay endQuiz = new Essay();
                this.xmlOutFile.write(endQuiz.closeQuiz());
                this.xmlInFile.close();
                this.inFileStream.close();
                this.xmlOutFile.flush();
                this.xmlOutFile.close();
                this.outFileStream.flush();
                this.outFileStream.close();
                continue;
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable file not found error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "File Not Found Error", 0);
                if (unzipped) {
                    FileUtilities.removeDirectory(this.zipFileFolder);
                }
                System.exit(-1);
                continue;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable IO error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "IO Error", 0);
                if (unzipped) {
                    FileUtilities.removeDirectory(this.zipFileFolder);
                }
                System.exit(-1);
                continue;
            }
            catch (ParsingException e) {
                JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable XML parse error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "XML Parse Error", 0);
                if (unzipped) {
                    FileUtilities.removeDirectory(this.zipFileFolder);
                }
                System.exit(-1);
                continue;
            }
            catch (NullPointerException ex) {
                if (z < this.inputFiles.size()) continue;
                JOptionPane.showMessageDialog(new JFrame(), "There was an error processing the file.\nRe-export the file in your test generator\nand please try again?", "File Processing Error", 0);
                if (!unzipped) continue;
                FileUtilities.removeDirectory(this.zipFileFolder);
            }
        }
        boolean dirDelete = FileUtilities.removeDirectory(this.zipFileFolder);
        unzipped = false;
        this.percentComplete = 100;
    }

    protected void findFiles(String rootDir, Regex r, String[] fileList) {
        for (int i = 0; i < fileList.length; ++i) {
            File f = new File(rootDir, fileList[i]);
            if (f.isDirectory()) {
                String path = f.getPath();
                this.findFiles(path, r, f.list());
                continue;
            }
            r.search(f.getName());
            if (!r.didMatch()) continue;
            this.inputFiles.add(f.getAbsolutePath());
        }
    }

    protected static String getStrElement(String str, int position) {
        Regex r = new Regex();
        String[] tokens = str.split(",");
        if (position == 0) {
            r = new Regex("\\[", "");
            str = r.replaceAll(tokens[0]).trim();
        } else if (position == 1) {
            str = tokens[1];
        } else if (position == 2) {
            r = new Regex("\\]", "");
            str = r.replaceAll(tokens[2]).trim();
        }
        return str;
    }
}

