/*
 * Decompiled with CFR 0.152.
 */
package edu.nashcc.moodlexml;

import com.stevesoft.pat.Regex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FileUtilities {
    public static void extractFolder(String zipFile) {
        try {
            int BUFFER = 2048;
            File file = new File(zipFile);
            ZipFile zip = new ZipFile(file);
            String newPath = zipFile.substring(0, zipFile.length() - 4);
            new File(newPath).mkdir();
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(newPath, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (!entry.isDirectory()) {
                    int currentByte;
                    BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                    byte[] data = new byte[BUFFER];
                    FileOutputStream fos = new FileOutputStream(destFile);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                    while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                        dest.write(data, 0, currentByte);
                    }
                    dest.flush();
                    dest.close();
                    is.close();
                }
                if (!currentEntry.endsWith(".zip")) continue;
                FileUtilities.extractFolder(destFile.getAbsolutePath());
            }
        }
        catch (ZipException zpex) {
            JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable file not found error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "File Not Found Error", 0);
            System.exit(-1);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(new JFrame(), "An unrecoverable IO error has occured.\nIf the problem persist email supoort and report the issue.\nExiting Program", "IO Error", 0);
            System.exit(-1);
        }
    }

    public static boolean FileOrDirectoryExists(String fileName) {
        File file = new File(fileName);
        boolean exists = file.exists();
        return exists;
    }

    public static String findFile(String rootDir, Regex r, String[] fileList) {
        String filePath = "";
        for (int i = 0; i < fileList.length; ++i) {
            File f = new File(rootDir, fileList[i]);
            if (f.isDirectory()) {
                String path = f.getPath();
                filePath = FileUtilities.findFile(path, r, f.list());
                if (filePath.equals("")) continue;
                i = fileList.length;
                return filePath;
            }
            r.search(f.getName());
            if (!r.didMatch()) continue;
            filePath = f.getAbsolutePath();
            i = fileList.length;
            return filePath;
        }
        return filePath;
    }

    public static String findDir(String rootDir, Regex r, String[] fileList) {
        String dirPath = "";
        for (int i = 0; i < fileList.length; ++i) {
            File f = new File(rootDir, fileList[i]);
            if (!f.isDirectory()) continue;
            String path = f.getPath();
            r.search(f.getName());
            if (r.didMatch()) {
                dirPath = f.getAbsolutePath();
                i = fileList.length;
                return dirPath;
            }
            dirPath = FileUtilities.findDir(path, r, f.list());
            if (dirPath.equals("")) continue;
            i = fileList.length;
            return dirPath;
        }
        return dirPath;
    }

    public static String convert(String fileName) {
        String convertedFileName = "";
        block5: for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            switch (ch) {
                case '*': {
                    convertedFileName = convertedFileName + "(.*)";
                    continue block5;
                }
                case '?': {
                    convertedFileName = convertedFileName + "(.)";
                    continue block5;
                }
                case '.': {
                    convertedFileName = convertedFileName + "\\.";
                    continue block5;
                }
                default: {
                    convertedFileName = convertedFileName + ch;
                }
            }
        }
        return "^" + convertedFileName + "$";
    }

    public static boolean removeDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        String[] list = directory.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(directory, list[i]);
                if (!(entry.isDirectory() ? !FileUtilities.removeDirectory(entry) : !entry.delete())) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public String findFiles(String rootDir, Regex r, String[] fileList) {
        String filePath = "";
        for (int i = 0; i < fileList.length; ++i) {
            File f = new File(rootDir, fileList[i]);
            if (f.isDirectory()) {
                String path = f.getPath();
                filePath = FileUtilities.findFile(path, r, f.list());
                continue;
            }
            r.search(f.getName());
            if (!r.didMatch()) continue;
            filePath = f.getAbsolutePath();
        }
        return filePath;
    }
}

