/*
 * Decompiled with CFR 0.152.
 */
package edu.nashcc.moodlexmlbuilder;

import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.List;

public abstract class Question {
    public String questiontype = "";
    public String name = "";
    public String questiontext = "";
    public String questionfile = "";
    public String questionfileBase64 = "";
    public List<List> questionImageList = new ArrayList<List>();
    public String generalfeedback = "";
    public List generalfeedbackImageList = new ArrayList();
    public float defaultgrade = 1.0f;
    public float penalty = 0.1f;
    public int shuffleanswers = 0;

    public static StringBuilder buildXMLHeader(String category) {
        StringBuilder xmlHeader = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlHeader.append("<!-- ******************** Nash Community College ******************* -->\n");
        xmlHeader.append("<!-- ********************* Rocky Mount, NC, USA ******************** -->\n");
        xmlHeader.append("<!-- ********************* Moodle XML Builder ******************** -->\n");
        xmlHeader.append("<!-- ****************** Developer: Gary Blackburn ****************** -->\n");
        xmlHeader.append("<quiz>\n\n");
        xmlHeader.append("\t<!-- Quiz Category  -->\n");
        xmlHeader.append("\t<question type=\"category\">\n");
        xmlHeader.append("\t\t<category>\n");
        xmlHeader.append("\t\t\t<text>$course$/");
        xmlHeader.append(category);
        xmlHeader.append("</text>\n");
        xmlHeader.append("\t\t</category>\n");
        xmlHeader.append("\t</question>\n\n");
        return xmlHeader;
    }

    protected static String getStrElement(String str, int position) {
        Regex r = new Regex();
        String[] tokens = str.split(",");
        if (position == 0) {
            r = new Regex("\\[", "");
            str = r.replaceAll(tokens[0]).trim();
        } else if (position == 1) {
            str = tokens[1];
        } else if (position == 2) {
            r = new Regex("\\]", "");
            str = r.replaceAll(tokens[2]).trim();
        }
        return str;
    }

    protected static StringBuilder buildXMLQuestion(StringBuilder baseQuestion, Question question) {
        int i;
        baseQuestion.append("\t\t<name>\n");
        baseQuestion.append("\t\t\t<text><![CDATA[");
        baseQuestion.append(question.name);
        baseQuestion.append("]]></text>\n");
        baseQuestion.append("\t\t</name>\n");
        baseQuestion.append("\t\t<questiontext format=\"html\">\n");
        baseQuestion.append("\t\t\t<text><![CDATA[<p>");
        baseQuestion.append(question.questiontext);
        baseQuestion.append("</p>]]></text>\n");
        for (i = 0; i < question.questionImageList.size(); ++i) {
            baseQuestion.append("\t\t\t<file name=\"");
            baseQuestion.append(Question.getStrElement(question.questionImageList.get(i).toString(), 0));
            baseQuestion.append("\" encoding=\"base64\">");
            baseQuestion.append(Question.getStrElement(question.questionImageList.get(i).toString(), 1));
            baseQuestion.append("\t\t\t</file>\n");
        }
        if (!question.questionfile.isEmpty() && !question.questionfile.equals("")) {
            baseQuestion.append("\t\t\t<file name=\"");
            baseQuestion.append(question.questionfile);
            baseQuestion.append("\" encoding=\"base64\">");
            baseQuestion.append(question.questionfileBase64);
            baseQuestion.append("\t\t\t</file>\n");
        }
        baseQuestion.append("\t\t</questiontext>\n");
        if (!question.generalfeedback.equals("")) {
            baseQuestion.append("\t\t<generalfeedback format=\"html\">\n");
            baseQuestion.append("\t\t\t<text><![CDATA[<p>");
            baseQuestion.append(question.generalfeedback);
            baseQuestion.append("</p>]]></text>\n");
            if (question.generalfeedbackImageList.size() > 0) {
                for (i = 0; i < question.generalfeedbackImageList.size(); ++i) {
                    baseQuestion.append("\t\t\t<file name=\"");
                    baseQuestion.append(Question.getStrElement(question.generalfeedbackImageList.get(i).toString(), 0));
                    baseQuestion.append("\" encoding=\"base64\">");
                    baseQuestion.append(Question.getStrElement(question.generalfeedbackImageList.get(i).toString(), 1));
                    baseQuestion.append("\t\t\t</file>\n");
                }
            }
            baseQuestion.append("\t\t</generalfeedback>\n");
        }
        baseQuestion.append("\t\t<defaultgrade>");
        baseQuestion.append(String.valueOf(question.defaultgrade));
        baseQuestion.append("</defaultgrade>\n");
        baseQuestion.append("\t\t<penalty>");
        baseQuestion.append(String.valueOf(question.penalty));
        baseQuestion.append("</penalty>\n");
        baseQuestion.append("\t\t<hidden>0</hidden>\n");
        if (question.questiontype.equals("MultiChoice")) {
            baseQuestion.append("\t\t<shuffleanswers>");
            baseQuestion.append(String.valueOf(question.shuffleanswers));
            baseQuestion.append("</shuffleanswers>\n");
        }
        return baseQuestion;
    }

    public String closeQuiz() {
        return "\n</quiz>";
    }
}

