/*
 * Decompiled with CFR 0.152.
 */
package edu.nashcc.moodlexmlbuilder.view;

import edu.nashcc.moodlexmlbuilder.view.MoodleXMLBuilderView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class AboutBox
extends JDialog {
    Image im = Toolkit.getDefaultToolkit().getImage("src/edu/nashcc/moodlexmlbuilder/view/resources/moodle_icon.jpg");
    protected Component entered = null;
    private JLabel appDescLabel;
    private JLabel appHomepageLabel;
    private JLabel appVersionLabel;
    private JLabel departmentLabel;
    private JLabel developerLabel;
    private JLabel homepageLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel moodleLogoLabel;
    private JLabel nccLogoLabel;
    private JLabel publisherLabel;
    private JLabel supportLabel;
    private JLabel versionLabel;

    public AboutBox(Frame owner) {
        this.initComponents();
        this.appVersionLabel.setText(MoodleXMLBuilderView.appVersion);
    }

    public static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void enter(Component c) {
        Cursor cursor = Cursor.getPredefinedCursor(12);
        this.setCursor(cursor);
        this.entered = c;
    }

    public void exit() {
        Cursor cursor = Cursor.getDefaultCursor();
        this.setCursor(cursor);
        if (this.entered != null) {
            this.entered = null;
        }
    }

    private void initComponents() {
        this.nccLogoLabel = new JLabel();
        this.moodleLogoLabel = new JLabel();
        this.appDescLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.appVersionLabel = new JLabel();
        this.publisherLabel = new JLabel();
        this.departmentLabel = new JLabel();
        this.homepageLabel = new JLabel();
        this.developerLabel = new JLabel();
        this.supportLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.appHomepageLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setIconImage(this.im);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setName("aboutBox");
        this.setResizable(false);
        this.nccLogoLabel.setIcon(new ImageIcon(this.getClass().getResource("/edu/nashcc/moodlexmlbuilder/view/resources/NCCLogo2small.jpg")));
        this.nccLogoLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AboutBox.this.nccLogoLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                AboutBox.this.nccLogoLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                AboutBox.this.nccLogoLabelMouseExited(evt);
            }
        });
        this.moodleLogoLabel.setFont(new Font("Tahoma", 1, 15));
        this.moodleLogoLabel.setIcon(new ImageIcon(this.getClass().getResource("/edu/nashcc/moodlexmlbuilder/view/resources/moodlelogo.gif")));
        this.moodleLogoLabel.setText("XML Builder");
        this.appDescLabel.setText("<html>A simple desktop application to convert popular test generator output to Moodle XML.");
        this.versionLabel.setFont(new Font("Tahoma", 1, 11));
        this.versionLabel.setText("Product Version:");
        this.publisherLabel.setFont(new Font("Tahoma", 1, 11));
        this.publisherLabel.setText("Publisher:");
        this.departmentLabel.setFont(new Font("Tahoma", 1, 11));
        this.departmentLabel.setText("Department:");
        this.homepageLabel.setFont(new Font("Tahoma", 1, 11));
        this.homepageLabel.setText("Homepage:");
        this.developerLabel.setFont(new Font("Tahoma", 1, 11));
        this.developerLabel.setText("Developer:");
        this.supportLabel.setFont(new Font("Tahoma", 1, 11));
        this.supportLabel.setText("Support:");
        this.jLabel1.setText("Nash Community College");
        this.jLabel2.setText("Engineering & Manufacturing Technologies");
        this.appHomepageLabel.setForeground(new Color(0, 0, 204));
        this.appHomepageLabel.setText("http://www.nashcc.edu/moodlexmlbuilder");
        this.appHomepageLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AboutBox.this.appHomepageLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                AboutBox.this.appHomepageLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                AboutBox.this.appHomepageLabelMouseExited(evt);
            }
        });
        this.jLabel4.setText("Gary Blackburn");
        this.jLabel5.setText("garyb@nashcc.edu");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nccLogoLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.appDescLabel, -2, 321, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versionLabel).addComponent(this.publisherLabel).addComponent(this.departmentLabel).addComponent(this.homepageLabel).addComponent(this.developerLabel).addComponent(this.supportLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.appHomepageLabel).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.appVersionLabel)))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.moodleLogoLabel).addGap(82, 82, 82)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.moodleLogoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.appDescLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.appVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.publisherLabel).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.departmentLabel).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.homepageLabel, -2, 14, -2).addComponent(this.appHomepageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.developerLabel).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.supportLabel).addComponent(this.jLabel5))).addComponent(this.nccLogoLabel));
        this.pack();
    }

    private void appHomepageLabelMouseClicked(MouseEvent evt) {
        try {
            URI uri = new URI("http://nashcc.edu/moodlexmlbuilder");
            AboutBox.open(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void appHomepageLabelMouseEntered(MouseEvent evt) {
        if (!(evt.getSource() instanceof Component)) {
            return;
        }
        this.exit();
        this.enter((Component)evt.getSource());
    }

    private void appHomepageLabelMouseExited(MouseEvent evt) {
        this.exit();
    }

    private void nccLogoLabelMouseClicked(MouseEvent evt) {
        try {
            URI uri = new URI("http://nashcc.edu/");
            AboutBox.open(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void nccLogoLabelMouseEntered(MouseEvent evt) {
        if (!(evt.getSource() instanceof Component)) {
            return;
        }
        this.exit();
        this.enter((Component)evt.getSource());
    }

    private void nccLogoLabelMouseExited(MouseEvent evt) {
        this.exit();
    }
}

